/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorParser;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class PackageDependencyParserImplTest
extends AbstractDpkgTest {
    private PackageNameParser packageNameParser;
    private PackageVersionRelationOperatorParser packageVersionRelationOperatorParser;
    private PackageVersionParser packageVersionParser;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.packageNameParser = new PackageNameParserImpl();
        this.packageVersionRelationOperatorParser = new PackageVersionRelationOperatorParserImpl();
        this.packageVersionParser = new PackageVersionParserImpl();
    }

    @Test
    public void testParsePackageDependency() {
        PackageDependency dependency;
        PackageDependencyParserImpl parser = new PackageDependencyParserImpl(this.packageNameParser, this.packageVersionRelationOperatorParser, this.packageVersionParser);
        ContextImpl context = new ContextImpl();
        try {
            parser.parsePackageDependency(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parsePackageDependency("libc6 (>= 2.14)", null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            dependency = parser.parsePackageDependency("libc6 (>= 2.14)", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)dependency);
        Assert.assertFalse((boolean)dependency.isCondition());
        Assert.assertNull((Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dependency.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dependency.getPackage());
        Assert.assertEquals((Object)"libc6", (Object)dependency.getPackage().getName());
        Assert.assertNotNull((Object)dependency.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dependency.getRelationOperator().getText());
        Assert.assertNotNull((Object)dependency.getVersion());
        Assert.assertNull((Object)dependency.getVersion().getEpoch());
        Assert.assertEquals((Object)"2.14", (Object)dependency.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)dependency.getVersion().getDebianRevision());
        try {
            dependency = parser.parsePackageDependency("libgcrypt20 (>=1.6.0-0)", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)dependency);
        Assert.assertFalse((boolean)dependency.isCondition());
        Assert.assertNull((Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dependency.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dependency.getPackage());
        Assert.assertEquals((Object)"libgcrypt20", (Object)dependency.getPackage().getName());
        Assert.assertNotNull((Object)dependency.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dependency.getRelationOperator().getText());
        Assert.assertNotNull((Object)dependency.getVersion());
        Assert.assertNull((Object)dependency.getVersion().getEpoch());
        Assert.assertEquals((Object)"1.6.0", (Object)dependency.getVersion().getUpstreamVersion());
        Assert.assertEquals((Object)"0", (Object)dependency.getVersion().getDebianRevision());
        try {
            dependency = parser.parsePackageDependency("util-linux (2.27.1-6ubuntu3.3)", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)dependency);
        Assert.assertFalse((boolean)dependency.isCondition());
        Assert.assertNull((Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dependency.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dependency.getPackage());
        Assert.assertEquals((Object)"util-linux", (Object)dependency.getPackage().getName());
        Assert.assertNull((Object)dependency.getRelationOperator());
        Assert.assertNotNull((Object)dependency.getVersion());
        Assert.assertNull((Object)dependency.getVersion().getEpoch());
        Assert.assertEquals((Object)"2.27.1", (Object)dependency.getVersion().getUpstreamVersion());
        Assert.assertEquals((Object)"6ubuntu3.3", (Object)dependency.getVersion().getDebianRevision());
        try {
            dependency = parser.parsePackageDependency("debconf (>= 0.5) | debconf-2.0", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)dependency);
        Assert.assertTrue((boolean)dependency.isCondition());
        Assert.assertEquals((Object)PackageDependency.Condition.OR, (Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)2L, (long)dependency.getConditionPackageDependencies().size());
        PackageDependency dep = (PackageDependency)dependency.getConditionPackageDependencies().get(0);
        Assert.assertFalse((boolean)dep.isCondition());
        Assert.assertNull((Object)dep.getCondition());
        Assert.assertNotNull((Object)dep.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dep.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dep.getPackage());
        Assert.assertEquals((Object)"debconf", (Object)dep.getPackage().getName());
        Assert.assertNotNull((Object)dep.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dep.getRelationOperator().getText());
        Assert.assertNotNull((Object)dep.getVersion());
        Assert.assertNull((Object)dep.getVersion().getEpoch());
        Assert.assertEquals((Object)"0.5", (Object)dep.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)dep.getVersion().getDebianRevision());
        dep = (PackageDependency)dependency.getConditionPackageDependencies().get(1);
        Assert.assertFalse((boolean)dep.isCondition());
        Assert.assertNull((Object)dep.getCondition());
        Assert.assertNotNull((Object)dep.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dep.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dep.getPackage());
        Assert.assertEquals((Object)"debconf-2.0", (Object)dep.getPackage().getName());
        Assert.assertNull((Object)dep.getRelationOperator());
        Assert.assertNull((Object)dep.getVersion());
        Assert.assertNull((Object)dependency.getPackage());
        Assert.assertNull((Object)dependency.getRelationOperator());
        Assert.assertNull((Object)dependency.getVersion());
    }

    @Test
    public void testParsePackageDependencies() {
        List dependencies;
        PackageDependencyParserImpl parser = new PackageDependencyParserImpl(this.packageNameParser, this.packageVersionRelationOperatorParser, this.packageVersionParser);
        ContextImpl context = new ContextImpl();
        try {
            parser.parsePackageDependencies(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parsePackageDependencies("libc6 (>= 2.14)", null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            dependencies = parser.parsePackageDependencies("libc6 (>= 2.14)", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)1L, (long)dependencies.size());
        PackageDependency dependency = (PackageDependency)dependencies.get(0);
        Assert.assertNotNull((Object)dependency);
        Assert.assertFalse((boolean)dependency.isCondition());
        Assert.assertNull((Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dependency.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dependency.getPackage());
        Assert.assertEquals((Object)"libc6", (Object)dependency.getPackage().getName());
        Assert.assertNotNull((Object)dependency.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dependency.getRelationOperator().getText());
        Assert.assertNotNull((Object)dependency.getVersion());
        Assert.assertNull((Object)dependency.getVersion().getEpoch());
        Assert.assertEquals((Object)"2.14", (Object)dependency.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)dependency.getVersion().getDebianRevision());
        try {
            dependencies = parser.parsePackageDependencies("libc6 (>= 2.14), debconf (>= 0.5) | debconf-2.0", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)dependencies);
        Assert.assertEquals((long)2L, (long)dependencies.size());
        dependency = (PackageDependency)dependencies.get(0);
        Assert.assertNotNull((Object)dependency);
        Assert.assertFalse((boolean)dependency.isCondition());
        Assert.assertNull((Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dependency.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dependency.getPackage());
        Assert.assertEquals((Object)"libc6", (Object)dependency.getPackage().getName());
        Assert.assertNotNull((Object)dependency.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dependency.getRelationOperator().getText());
        Assert.assertNotNull((Object)dependency.getVersion());
        Assert.assertNull((Object)dependency.getVersion().getEpoch());
        Assert.assertEquals((Object)"2.14", (Object)dependency.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)dependency.getVersion().getDebianRevision());
        dependency = (PackageDependency)dependencies.get(1);
        Assert.assertNotNull((Object)dependency);
        Assert.assertTrue((boolean)dependency.isCondition());
        Assert.assertEquals((Object)PackageDependency.Condition.OR, (Object)dependency.getCondition());
        Assert.assertNotNull((Object)dependency.getConditionPackageDependencies());
        Assert.assertEquals((long)2L, (long)dependency.getConditionPackageDependencies().size());
        PackageDependency dep = (PackageDependency)dependency.getConditionPackageDependencies().get(0);
        Assert.assertFalse((boolean)dep.isCondition());
        Assert.assertNull((Object)dep.getCondition());
        Assert.assertNotNull((Object)dep.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dep.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dep.getPackage());
        Assert.assertEquals((Object)"debconf", (Object)dep.getPackage().getName());
        Assert.assertNotNull((Object)dep.getRelationOperator());
        Assert.assertEquals((Object)">=", (Object)dep.getRelationOperator().getText());
        Assert.assertNotNull((Object)dep.getVersion());
        Assert.assertNull((Object)dep.getVersion().getEpoch());
        Assert.assertEquals((Object)"0.5", (Object)dep.getVersion().getUpstreamVersion());
        Assert.assertNull((Object)dep.getVersion().getDebianRevision());
        dep = (PackageDependency)dependency.getConditionPackageDependencies().get(1);
        Assert.assertFalse((boolean)dep.isCondition());
        Assert.assertNull((Object)dep.getCondition());
        Assert.assertNotNull((Object)dep.getConditionPackageDependencies());
        Assert.assertEquals((long)0L, (long)dep.getConditionPackageDependencies().size());
        Assert.assertNotNull((Object)dep.getPackage());
        Assert.assertEquals((Object)"debconf-2.0", (Object)dep.getPackage().getName());
        Assert.assertNull((Object)dep.getRelationOperator());
        Assert.assertNull((Object)dep.getVersion());
        Assert.assertNull((Object)dependency.getPackage());
        Assert.assertNull((Object)dependency.getRelationOperator());
        Assert.assertNull((Object)dependency.getVersion());
    }
}

