/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyParser;
import net.sourceforge.javadpkg.control.PackageNameBuilder;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackageVersionBuilder;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorBuilder;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorParser;
import net.sourceforge.javadpkg.control.impl.PackageDependencyBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class PackageDependencyBuilderImplTest
extends AbstractDpkgTest {
    private PackageNameBuilder packageNameBuilder;
    private PackageVersionRelationOperatorBuilder packageVersionRelationOperatorBuilder;
    private PackageVersionBuilder packageVersionBuilder;
    private PackageNameParser packageNameParser;
    private PackageVersionRelationOperatorParser packageVersionRelationOperatorParser;
    private PackageVersionParser packageVersionParser;
    private PackageDependencyParser packageDependencyParser;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.packageNameBuilder = new PackageNameBuilderImpl();
        this.packageVersionRelationOperatorBuilder = new PackageVersionRelationOperatorBuilderImpl();
        this.packageVersionBuilder = new PackageVersionBuilderImpl();
        this.packageNameParser = new PackageNameParserImpl();
        this.packageVersionRelationOperatorParser = new PackageVersionRelationOperatorParserImpl();
        this.packageVersionParser = new PackageVersionParserImpl();
        this.packageDependencyParser = new PackageDependencyParserImpl(this.packageNameParser, this.packageVersionRelationOperatorParser, this.packageVersionParser);
    }

    @Test
    public void testBuildPackageDependency() {
        String value;
        PackageDependencyBuilderImpl builder = new PackageDependencyBuilderImpl(this.packageNameBuilder, this.packageVersionRelationOperatorBuilder, this.packageVersionBuilder);
        PackageDependency dependency = this.createPackageDependency("libc6 (>= 2.14)");
        ContextImpl context = new ContextImpl();
        try {
            builder.buildPackageDependency(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildPackageDependency(dependency, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            value = builder.buildPackageDependency(dependency, (Context)context);
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"libc6 (>= 2.14)", (Object)value);
        dependency = this.createPackageDependency("debconf (>= 0.5) | debconf-2.0");
        try {
            value = builder.buildPackageDependency(dependency, (Context)context);
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"debconf (>= 0.5) | debconf-2.0", (Object)value);
    }

    @Test
    public void testBuildPackageDependencies() {
        String value;
        PackageDependencyBuilderImpl builder = new PackageDependencyBuilderImpl(this.packageNameBuilder, this.packageVersionRelationOperatorBuilder, this.packageVersionBuilder);
        List<PackageDependency> dependencies = this.createPackageDependencies("libc6 (>= 2.14)");
        ContextImpl context = new ContextImpl();
        try {
            builder.buildPackageDependencies(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildPackageDependencies(dependencies, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            value = builder.buildPackageDependencies(dependencies, (Context)context);
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"libc6 (>= 2.14)", (Object)value);
        dependencies = this.createPackageDependencies("libc6 (>= 2.14), debconf (>= 0.5) | debconf-2.0");
        try {
            value = builder.buildPackageDependencies(dependencies, (Context)context);
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"libc6 (>= 2.14), debconf (>= 0.5) | debconf-2.0", (Object)value);
    }

    private PackageDependency createPackageDependency(String value) {
        PackageDependency dependency;
        ContextImpl context = new ContextImpl();
        try {
            dependency = this.packageDependencyParser.parsePackageDependency(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare dependency |" + value + "|: An unexpected exception was thrown: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't prepare dependency |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return dependency;
    }

    private List<PackageDependency> createPackageDependencies(String value) {
        List dependencies;
        ContextImpl context = new ContextImpl();
        try {
            dependencies = this.packageDependencyParser.parsePackageDependencies(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare dependencies " + value + ": An unexpected exception was thrown: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't prepare dependency |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return dependencies;
    }
}

