/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionParser;
import net.sourceforge.javadpkg.control.impl.DescriptionBuilderImpl;
import net.sourceforge.javadpkg.control.impl.DescriptionParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class DescriptionBuilderImplTest
extends AbstractDpkgTest {
    private DescriptionParser parser;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.parser = new DescriptionParserImpl();
    }

    @Test
    public void test() {
        String value;
        DescriptionBuilderImpl builder = new DescriptionBuilderImpl();
        ContextImpl context = new ContextImpl();
        Description description = this.createDescription("This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        try {
            builder.buildDescription(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildDescription(description, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            value = builder.buildDescription(description, (Context)context);
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.", (Object)value);
    }

    private Description createDescription(String value) {
        Description description;
        ContextImpl context = new ContextImpl();
        try {
            description = this.parser.parseDescription(value, (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare the dependency |" + value + "|: " + e.getMessage()));
            return null;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((String)("Couldn't prepare the dependency |" + value + "|: Got " + warnings.size() + " warning(s)."), (long)0L, (long)warnings.size());
        return description;
    }
}

