/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import org.junit.Assert;
import org.junit.Test;

import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataSwap;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataTempFileSwap;


/**
 * <p>
 * Performs some tests on the {@link DataTempFileSwap} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
 */
public class DataTempFileSwapTest extends AbstractDpkgTest {


	/**
	 * <p>
	 * Performs some tests on the {@link DataTempFileSwap} class.
	 * </p>
	 */
	@Test
	public void test() {
		StringBuffer sb;
		String line;


		sb = new StringBuffer();
		try {
			try (DataSwap swap = new DataTempFileSwap("test")) {
				try (DataTarget target = swap.getTarget()) {
					try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), "UTF-8"))) {
						out.write("Hello\nWorld!");
					}
				}
				try (DataSource source = swap.getSource()) {
					try (BufferedReader in = new BufferedReader(new InputStreamReader(source.getInputStream(), "UTF-8"))) {
						while ((line = in.readLine()) != null) {
							if (sb.length() > 0) {
								sb.append('\n');
							}
							sb.append(line);
						}
					}
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		Assert.assertEquals("Hello\nWorld!", sb.toString());
	}
	
	
}
