/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;

import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.ScriptParser;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.ScriptParserImpl;
import net.sourceforge.javadpkg.io.DataSource;


/**
 * <p>
 * Performs some tests on the {@link ScriptParserImpl} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public class ScriptParserImplTest extends AbstractDpkgTest {


	/**
	 * <p>
	 * Performs some tests on the {@link ScriptParserImpl} class.
	 * </p>
	 */
	@SuppressWarnings("resource")
	@Test
	public void test() {
		ScriptParser parser;
		DataSource source;
		Context context;
		Script script;
		List<Warning> warnings;


		parser = new ScriptParserImpl();

		// --- Parameters ---
		source = createSource(Arrays.asList("#!/bin/sh", "# --- Enable error detection. ---", "set -e", "",
				"# --- Set version of this package ---", "THISVERSION=\"${deb.version}\"", "",
				"echo Pre-installation script version $THISVERSION", "echo \"   Parameters                  : $@\"",
				"echo \"   Option                      : $1\"", "echo \"   Currently installed version : $2\"",
				"echo \"   Version of this package     : $THISVERSION\"", "", "case \"$1\" in", "    install)",
				"        echo \"   No tasks.\"", "        ;;", "    upgrade)", "        echo \"   No tasks.\"", "        ;;",
				"    *)", "        echo \"   Option $1 not supported by this script.\"", "        ;;", "esac", ""), "preinst");
		context = new ContextImpl();
		try {
			parser.parseScript(null, context);
			Assert.fail("Expected an exception, but none was thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (IOException | ParseException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		try {
			parser.parseScript(source, null);
			Assert.fail("Expected an exception, but none was thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (IOException | ParseException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}


		// --- Parse successfully ---
		try {
			script = parser.parseScript(source, context);
		} catch (IOException | ParseException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		warnings = context.getWarnings();
		Assert.assertNotNull(warnings);
		Assert.assertEquals(0, warnings.size());
		Assert.assertNotNull(script);
		Assert.assertEquals("#!/bin/sh\n" + "# --- Enable error detection. ---\n" + "set -e\n" + "\n"
				+ "# --- Set version of this package ---\n" + "THISVERSION=\"${deb.version}\"\n" + "\n"
				+ "echo Pre-installation script version $THISVERSION\n" + "echo \"   Parameters                  : $@\"\n"
				+ "echo \"   Option                      : $1\"\n" + "echo \"   Currently installed version : $2\"\n"
				+ "echo \"   Version of this package     : $THISVERSION\"\n" + "\n" + "case \"$1\" in\n" + "    install)\n"
				+ "        echo \"   No tasks.\"\n" + "        ;;\n" + "    upgrade)\n" + "        echo \"   No tasks.\"\n"
				+ "        ;;\n" + "    *)\n" + "        echo \"   Option $1 not supported by this script.\"\n" + "        ;;\n"
				+ "esac\n", script.getText());
	}
	
	
}
