/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.field.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;

import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldBuilder;
import net.sourceforge.javadpkg.field.impl.FieldBuilderImpl;
import net.sourceforge.javadpkg.field.impl.FieldImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;


/**
 * <p>
 * Performs some tests on the {@link FieldBuilderImpl} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
 */
public class FieldBuilderImplTest extends AbstractDpkgTest {


	/**
	 * <p>
	 * Performs some tests on the {@link FieldBuilderImpl} class.
	 * </p>
	 */
	@SuppressWarnings("resource")
	@Test
	public void test() {
		FieldBuilder builder;
		List<Field> fields;
		ByteArrayOutputStream out;
		DataTarget target;
		Context context;
		List<Warning> warnings;


		builder = new FieldBuilderImpl();
		fields = new ArrayList<>();
		fields.add(new FieldImpl("Package", "mypackage"));
		fields.add(new FieldImpl("Version", "1.0.0"));
		fields.add(new FieldImpl("Section", "net"));
		fields.add(new FieldImpl("Priority", "optional"));
		fields.add(new FieldImpl("Architecture", "amd64"));
		fields.add(new FieldImpl("Depends", "oracle-8-jre (>= 1.8.0)"));
		fields.add(new FieldImpl("Installed-Size", "12345"));
		fields.add(new FieldImpl("Homepage", "http://www.example.com/"));
		fields.add(new FieldImpl("Maintainer", "John Doe <j.doe@example.com>"));
		fields.add(new FieldImpl("Description",
				"This is my first package.\n" + "I'm somewhat excited.\n" + ".\n" + "This will be a great package.\n" + "."));
		out = new ByteArrayOutputStream();
		target = new DataStreamTarget(out, "control", false);
		context = new ContextImpl();
		
		// --- Parameters ---
		try {
			builder.buildFields(null, target, context);
			Assert.fail("Expected an exception, but none was thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (IOException | BuildException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		try {
			builder.buildFields(fields, null, context);
			Assert.fail("Expected an exception, but none was thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (IOException | BuildException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		try {
			builder.buildFields(fields, target, null);
			Assert.fail("Expected an exception, but none was thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (IOException | BuildException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		
		
		// --- Build successfully ---
		try {
			builder.buildFields(fields, target, context);
		} catch (IOException | BuildException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		warnings = context.getWarnings();
		Assert.assertNotNull(warnings);
		Assert.assertEquals(0, warnings.size());

		Assert.assertEquals("Package: mypackage\n" + "Version: 1.0.0\n" + "Section: net\n" + "Priority: optional\n"
				+ "Architecture: amd64\n" + "Depends: oracle-8-jre (>= 1.8.0)\n" + "Installed-Size: 12345\n"
				+ "Homepage: http://www.example.com/\n" + "Maintainer: John Doe <j.doe@example.com>\n"
				+ "Description: This is my first package.\n" + " I'm somewhat excited.\n" + " .\n"
				+ " This will be a great package.\n" + " .\n", new String(out.toByteArray()));
	}


}
