/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.junit.Assert;
import org.junit.Test;

import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.ControlBuilder;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.control.impl.ControlBuilderImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;


/**
 * <p>
 * Performs some tests on the {@link ControlBuilderImpl} class.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class ControlBuilderImplTest extends AbstractDpkgTest {
	
	
	/**
	 * <p>
	 * Performs some tests on the
	 * {@link ControlBuilderImpl#buildControl(Control, DataTarget, Context)}
	 * method.
	 * </p>
	 */
	@SuppressWarnings("resource")
	@Test
	public void testBuildControlControlDataTargetContext() {
		ControlBuilder builder;
		BinaryControlImpl control;
		ByteArrayOutputStream out;
		DataTarget target;
		Context context;


		builder = new ControlBuilderImpl();


		// --- Parameters ---
		context = new ContextImpl();
		control = createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)",
				Long.valueOf(12345), "http://www.example.com/", "John Doe <j.doe@example.com>",
				"This is my first package.\n" + "I'm somewhat excited.\n" + ".\n" + "This will be a great package.\n" + ".");
		out = new ByteArrayOutputStream();
		target = new DataStreamTarget(out, "control", false);
		context = new ContextImpl();
		try {
			builder.buildControl(null, target, context);
			Assert.fail("Expected an exception, but none wa thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (BuildException | IOException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		try {
			builder.buildControl(control, null, context);
			Assert.fail("Expected an exception, but none wa thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (BuildException | IOException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		try {
			builder.buildControl(control, target, null);
			Assert.fail("Expected an exception, but none wa thrown.");
		} catch (IllegalArgumentException e) {
			// --- Expected exception. Do nothing. ---
		} catch (BuildException | IOException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}


		// --- Build ---
		try {
			builder.buildControl(control, target, context);
		} catch (BuildException | IOException e) {
			e.printStackTrace();
			Assert.fail("An unexpected exception was thrown: " + e.getMessage());
			return;
		}
		Assert.assertEquals("Package: mypackage\n" + "Version: 1.0.0\n" + "Architecture: amd64\n" + "Section: net\n"
				+ "Priority: optional\n" + "Depends: oracle-8-jre (>= 1.8.0)\n" + "Installed-Size: 12345\n"
				+ "Maintainer: John Doe <j.doe@example.com>\n" + "Homepage: http://www.example.com/\n"
				+ "Description: This is my first package.\n" + " I'm somewhat excited.\n" + " .\n"
				+ " This will be a great package.\n" + " .\n", new String(out.toByteArray()));
	}


}
