/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.replace;

import net.sourceforge.javadpkg.Context;


/**
 * <p>
 * A {@link Replacer} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public class ReplacerImpl implements Replacer {
	
	
	/**
	 * <p>
	 * Creates a replacer.
	 * </p>
	 */
	public ReplacerImpl() {
		super();
	}
	
	
	@Override
	public String replace(String line, Replacements replacements, Context context) throws ReplacementException {
		int lastIndex, index;
		StringBuilder sb = null;
		String name, value;


		if (line == null)
			throw new IllegalArgumentException("Argument line is null.");
		if (replacements == null)
			throw new IllegalArgumentException("Argument replacements is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
		
		// --- Do we have an empty line? ---
		if (line.isEmpty())
			return line;
		
		/*
		 * --- Go from one variable to the next variable.
		 *     Add the text between them to the builder.
		 *     Try to replace the variables by their values.
		 */
		lastIndex = 0;
		index = 0;
		while (index != -1) {
			index = line.indexOf("${", index);
			if (index >= 0) {
				if (sb == null) {
					sb = new StringBuilder();
				}
				sb.append(line.substring(lastIndex, index));
				lastIndex = index + 2;
				index = line.indexOf("}", lastIndex);
				if (index == -1)
					throw new ReplacementException("Found the beginning of a variable |" + line.substring(lastIndex)
							+ "|, but no end in line |" + line + "|.");
				name = line.substring(lastIndex, index);
				lastIndex = index + 1;
				index = lastIndex;
				
				value = replacements.getValue(name);
				if (value == null) {
					context.addWarning(new ReplacementVariableUnknownWarning(name));
					sb.append("${");
					sb.append(name);
					sb.append('}');
				} else {
					sb.append(value);
				}
			} else if (sb != null) {
				sb.append(line.substring(lastIndex));
			}
		}
		// --- Did we find no variables? ---
		if (sb == null)
			return line;
		return sb.toString();
	}
	
	
}
