/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.replace;

import java.util.Map;
import java.util.TreeMap;

/**
 * <p>
 * A {@link Replacements} implementation which is based on a {@link Map}.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public class ReplacementsMap implements Replacements {
	
	
	/** The variables and their values. */
	private Map<String, String> variables;


	/**
	 * <p>
	 * Creates replacements.
	 * </p>
	 */
	public ReplacementsMap() {
		super();

		this.variables = new TreeMap<>();
	}


	/**
	 * <p>
	 * Creates replacements.
	 * </p>
	 *
	 * @param variables
	 *            The variables and their values.
	 * @throws IllegalArgumentException
	 *             If the map containing the variables and their values is
	 *             <code>null</code>.
	 */
	public ReplacementsMap(Map<String, String> variables) {
		super();

		if (variables == null)
			throw new IllegalArgumentException("Argument variables is null.");
		
		this.variables = new TreeMap<>(variables);
	}
	
	
	@Override
	public String getValue(String name) throws ReplacementException {
		if (name == null)
			throw new IllegalArgumentException("Argument name is null.");
		
		return this.variables.get(name);
	}


}
