/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io.impl;

import net.sourceforge.javadpkg.io.FileOwner;

/**
 * <p>
 * A {@link FileOwner} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 12.05.2016 by Gerrit Hohl
 */
public class FileOwnerImpl implements FileOwner {
	
	
	/** The group ID. */
	private long	groupId;
	/** The group name. */
	private String	groupName;
	/** The user ID. */
	private long	userId;
	/** The user name. */
	private String	userName;


	/**
	 * <p>
	 * Creates a file owner.
	 * </p>
	 *
	 * @param groupId
	 *            The group ID.
	 * @param groupName
	 *            The group name.
	 * @param userId
	 *            The user ID.
	 * @param userName
	 *            The user name.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	public FileOwnerImpl(long groupId, String groupName, long userId, String userName) {
		super();

		if (groupName == null)
			throw new IllegalArgumentException("Argument groupName is null.");
		if (userName == null)
			throw new IllegalArgumentException("Argument userName is null.");
		
		this.groupId = groupId;
		this.groupName = groupName;
		this.userId = userId;
		this.userName = userName;
	}


	@Override
	public long getGroupId() {
		return this.groupId;
	}


	@Override
	public String getGroupName() {
		return this.groupName;
	}


	@Override
	public long getUserId() {
		return this.userId;
	}


	@Override
	public String getUserName() {
		return this.userName;
	}


}
