/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.Closeable;
import java.io.IOException;

import net.sourceforge.javadpkg.io.CloseHandler;

/**
 * <p>
 * A {@link CloseHandler} implementation which delegates the {@link #closed()}
 * method call to the {@link Closeable#close()} method of a {@link Closeable}
 * object.
 * </p>
 * 
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public class DelegateCloseHandler implements CloseHandler {
	
	
	/** The object which can be closed. */
	private Closeable closeable;


	/**
	 * <p>
	 * Creates a handler.
	 * </p>
	 * 
	 * @param closeable
	 *            The object which can be closed.
	 * @throws IllegalArgumentException
	 *             If the object is <code>null</code>.
	 */
	public DelegateCloseHandler(Closeable closeable) {
		super();

		if (closeable == null)
			throw new IllegalArgumentException("Argument closeable is null.");
			
		this.closeable = closeable;
	}
	
	
	@Override
	public void closed() throws IOException {
		this.closeable.close();
	}


}
