/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io;

import java.io.Closeable;
import java.io.IOException;

/**
 * <p>
 * A swap can be used for storing data temporarily.
 * </p>
 * <p>
 * A swap consists of a {@link DataTarget} which can be used to write the data
 * and a {@link DataSource} to read it afterwards. When the swap is closed the
 * stored data will be deleted.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
 */
public interface DataSwap extends Closeable {


	/**
	 * <p>
	 * Returns the target.
	 * </p>
	 * <p>
	 * Subsequent calls will return the same target.
	 * </p>
	 *
	 * @return The target.
	 * @throws IllegalStateException
	 *             If the {@link #getSource()} method has been already called.
	 * @throws IOException
	 *             If an I/O error occurs while creating the target.
	 */
	DataTarget getTarget() throws IOException;
	
	
	/**
	 * <p>
	 * Returns the source.
	 * </p>
	 * <p>
	 * Subsequent calls will return the same source.
	 * </p>
	 *
	 * @return The source.
	 * @throws IllegalStateException
	 *             If the {@link #getTarget()} method hasn't been called before.
	 * @throws IOException
	 *             If an I/O error occurs while creating the source.
	 */
	DataSource getSource() throws IOException;


}
