/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.io;

import java.io.IOException;

/**
 * <p>
 * A consumer which accepts data for further processing.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 27.04.2016 by Gerrit Hohl
 */
public interface DataConsumer {


	/**
	 * <p>
	 * Returns the name of the consumer in the exception (if one is thrown).
	 * </p>
	 *
	 * @return The name.
	 */
	String getName();


	/**
	 * <p>
	 * Consume the data.
	 * </p>
	 *
	 * @param buffer
	 *            The buffer containing the data.
	 * @param length
	 *            The length which defines how much of the buffer is filled with
	 *            data.
	 * @throws IOException
	 *             If an I/O error occurs.
	 */
	void consume(byte[] buffer, int length) throws IOException;
	
	
}
