/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning for a missing field in the templates.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 25.04.2016 by Gerrit Hohl
 */
public class TemplatesMissingFieldWarning implements Warning {
	
	
	/** The name of the template. */
	private String	name;
	/** The field name. */
	private String	fieldName;


	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 *
	 * @param name
	 *            The name of the template.
	 * @param fieldName
	 *            The field name.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 */
	public TemplatesMissingFieldWarning(String name, String fieldName) {
		super();
		
		if (name == null)
			throw new IllegalArgumentException("Argument name is null.");
		if (fieldName == null)
			throw new IllegalArgumentException("Argument fieldName is null.");

		this.name = name;
		this.fieldName = fieldName;
	}
	
	
	@Override
	public String getText() {
		StringBuilder sb;
		
		
		sb = new StringBuilder();
		sb.append("Missing field |");
		sb.append(this.fieldName);
		sb.append("| in template |");
		sb.append(this.name);
		sb.append("| in the templates.");
		
		return sb.toString();
	}
	
	
}
