/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning about an unsupported template type.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
 */
public class TemplateTypeUnsupportedWarning implements Warning {
	
	
	/** The template type. */
	private String type;
	
	
	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 *
	 * @param type
	 *            The template type.
	 * @throws IllegalArgumentException
	 *             If the template type is <code>null</code>.
	 */
	public TemplateTypeUnsupportedWarning(String type) {
		super();
		
		if (type == null)
			throw new IllegalArgumentException("Argument type is null.");
			
		this.type = type;
	}


	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		sb.append("Found unsupported template type |");
		sb.append(this.type);
		sb.append("|.");

		return sb.toString();
	}


}
