/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.ScriptVariableReplacer;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.Replacements;
import net.sourceforge.javadpkg.replace.Replacer;
import net.sourceforge.javadpkg.replace.ReplacerImpl;


/**
 * <p>
 * A {@link ScriptVariableReplacer} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public class ScriptVariableReplacerImpl implements ScriptVariableReplacer {
	
	
	/** The replacer. */
	private Replacer replacer;
	
	
	/**
	 * <p>
	 * Creates a replacer.
	 * </p>
	 */
	public ScriptVariableReplacerImpl() {
		super();
		
		this.replacer = new ReplacerImpl();
	}
	
	
	@Override
	public Script replaceScriptVariables(Script script, Replacements replacements, Context context)
			throws ReplacementException {
		
		Script result;
		List<String> lines;
		String replaced;
		
		
		if (script == null)
			throw new IllegalArgumentException("Argument script is null.");
		if (replacements == null)
			throw new IllegalArgumentException("Argument replacements is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
		
		lines = new ArrayList<>();
		for (String line : script.getLines()) {
			replaced = this.replacer.replace(line, replacements, context);
			lines.add(replaced);
		}
		result = new ScriptImpl(lines);
		return result;
	}
	
	
}
