/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.javadpkg.Script;


/**
 * <p>
 * A {@link Script} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public class ScriptImpl implements Script {


	/** The lines. */
	private List<String> lines;


	/**
	 * <p>
	 * Creates a script.
	 * </p>
	 */
	public ScriptImpl() {
		super();
		
		this.lines = new ArrayList<>();
	}


	/**
	 * <p>
	 * Creates a script.
	 * </p>
	 * 
	 * @param lines
	 *            The lines.
	 * @throws IllegalArgumentException
	 *             If the lines are <code>null</code>.
	 */
	public ScriptImpl(List<String> lines) {
		super();
		
		if (lines == null)
			throw new IllegalArgumentException("Argument lines is null.");

		this.lines = new ArrayList<>(lines);
	}


	@Override
	public List<String> getLines() {
		return (new ArrayList<>(this.lines));
	}


	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		for (String line : this.lines) {
			if (sb.length() > 0) {
				sb.append('\n');
			}
			sb.append(line);
		}
		return sb.toString();
	}
	
	
}
