/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.ScriptBuilder;
import net.sourceforge.javadpkg.io.DataTarget;


/**
 * <p>
 * A {@link ScriptBuilder} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public class ScriptBuilderImpl implements ScriptBuilder, GlobalConstants {


	/**
	 * <p>
	 * Creates a builder.
	 * </p>
	 */
	public ScriptBuilderImpl() {
		super();
	}


	@Override
	public void buildScript(DataTarget target, Script script) throws IOException, BuildException {
		if (target == null)
			throw new IllegalArgumentException("Argument target is null.");
		if (script == null)
			throw new IllegalArgumentException("Argument script is null.");
			
		try {
			try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), UTF_8_CHARSET))) {
				writer.write(script.getText());
			}
		} catch (IOException e) {
			throw new IOException("Couldn't build script |" + target.getName() + "|: " + e.getMessage(), e);
		}
	}


}
