/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ConfigFiles;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.DebianPackage;
import net.sourceforge.javadpkg.MD5Sums;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.SharedLibraries;
import net.sourceforge.javadpkg.Symbols;
import net.sourceforge.javadpkg.Templates;
import net.sourceforge.javadpkg.control.Control;


/**
 * <p>
 * A {@link DebianPackage} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public class DebianPackageImpl implements DebianPackage {
	
	
	/** The version of the file format. */
	private String			fileFormatVersion;
	/** The control of the package. */
	private Control			control;
	/** The MD5 sums. */
	private MD5Sums			md5Sums;
	/** The script which will be executed before the package is installed. */
	private Script			preInstall;
	/** The script which will be executed after the package is installed. */
	private Script			postInstall;
	/** The script which will be executed before the package is removed. */
	private Script			preRemove;
	/** The script which will be executed after the package is removed. */
	private Script			postRemove;
	/** The templates for asking the user questions about the configuration. */
	private Templates		templates;
	/** The script for the configuration of the package. */
	private Script			config;
	/** The configuration files which are managed by this package. */
	private ConfigFiles		configFiles;
	/** The shared libraries of this package. */
	private SharedLibraries	sharedLibraries;
	/** The symbols of the shared libraries of this package. */
	private Symbols			symbols;
	/** The copyright of this package. */
	private Copyright		copyright;
	/** The change log of this package. */
	private ChangeLog		changeLog;


	/**
	 * <p>
	 * Creates a Debian package.
	 * </p>
	 */
	public DebianPackageImpl() {
		super();

		this.fileFormatVersion = null;
		this.control = null;
		this.md5Sums = null;
		this.preInstall = null;
		this.postInstall = null;
		this.preRemove = null;
		this.postRemove = null;
		this.templates = null;
		this.config = null;
		this.configFiles = null;
		this.sharedLibraries = null;
		this.symbols = null;
		this.copyright = null;
		this.changeLog = null;
	}
	
	
	@Override
	public String getFileFormatVersion() {
		return this.fileFormatVersion;
	}


	/**
	 * <p>
	 * Sets the version of the file format.
	 * </p>
	 * <p>
	 * In most cases this should be &quot;2.0&quot;
	 * </p>
	 *
	 * @param fileFormatVersion
	 *            The version.
	 */
	public void setFileFormatVersion(String fileFormatVersion) {
		this.fileFormatVersion = fileFormatVersion;
	}


	@Override
	public Control getControl() {
		return this.control;
	}


	/**
	 * <p>
	 * Sets the control of the package.
	 * </p>
	 *
	 * @param control
	 *            The control.
	 */
	public void setControl(Control control) {
		this.control = control;
	}


	@Override
	public MD5Sums getMD5Sums() {
		return this.md5Sums;
	}


	/**
	 * <p>
	 * Sets the MD5 sums.
	 * </p>
	 *
	 * @param md5Sums
	 *            The MD5 sums.
	 */
	public void setMD5Sums(MD5Sums md5Sums) {
		this.md5Sums = md5Sums;
	}


	@Override
	public Script getPreInstall() {
		return this.preInstall;
	}
	
	
	/**
	 * <p>
	 * Sets the script which will be executed before the package is installed.
	 * </p>
	 *
	 * @param preInstall
	 *            The script.
	 */
	public void setPreInstall(Script preInstall) {
		this.preInstall = preInstall;
	}


	@Override
	public Script getPostInstall() {
		return this.postInstall;
	}
	
	
	/**
	 * <p>
	 * Sets the script which will be executed after the package is installed.
	 * </p>
	 *
	 * @param postInstall
	 *            The script.
	 */
	public void setPostInstall(Script postInstall) {
		this.postInstall = postInstall;
	}


	@Override
	public Script getPreRemove() {
		return this.preRemove;
	}


	/**
	 * <p>
	 * Sets the script which will be executed after the package is installed.
	 * </p>
	 *
	 * @param preRemove
	 *            The script.
	 */
	public void setPreRemove(Script preRemove) {
		this.preRemove = preRemove;
	}


	@Override
	public Script getPostRemove() {
		return this.postRemove;
	}


	/**
	 * <p>
	 * Sets the script which will be executed after the package is removed.
	 * </p>
	 *
	 * @param postRemove
	 *            The script.
	 */
	public void setPostRemove(Script postRemove) {
		this.postRemove = postRemove;
	}


	@Override
	public Templates getTemplates() {
		return this.templates;
	}
	
	
	/**
	 * <p>
	 * Sets the templates for asking the user questions about the configuration.
	 * </p>
	 *
	 * @param templates
	 *            The templates.
	 * @see #setConfig(Script)
	 */
	public void setTemplates(Templates templates) {
		this.templates = templates;
	}


	@Override
	public Script getConfig() {
		return this.config;
	}
	
	
	/**
	 * <p>
	 * Sets the script for the configuration of the package.
	 * </p>
	 *
	 * @param config
	 *            The script.
	 * @see #setTemplates(Templates)
	 */
	public void setConfig(Script config) {
		this.config = config;
	}


	@Override
	public ConfigFiles getConfigFiles() {
		return this.configFiles;
	}
	
	
	/**
	 * <p>
	 * Sets the configuration files which are managed by this package.
	 * </p>
	 *
	 * @param configFiles
	 *            The configuration files.
	 */
	public void setConfigFiles(ConfigFiles configFiles) {
		this.configFiles = configFiles;
	}


	@Override
	public SharedLibraries getSharedLibraries() {
		return this.sharedLibraries;
	}


	/**
	 * <p>
	 * Sets the shared libraries of this package.
	 * </p>
	 *
	 * @param sharedLibraries
	 *            The shared libraries.
	 */
	public void setSharedLibraries(SharedLibraries sharedLibraries) {
		this.sharedLibraries = sharedLibraries;
	}


	@Override
	public Symbols getSymbols() {
		return this.symbols;
	}


	/**
	 * <p>
	 * Sets the symbols of the shared libraries of this package.
	 * </p>
	 *
	 * @param symbols
	 *            The symbols.
	 */
	public void setSymbols(Symbols symbols) {
		this.symbols = symbols;
	}
	
	
	@Override
	public Copyright getCopyright() {
		return this.copyright;
	}
	
	
	/**
	 * <p>
	 * Sets the copyright of this package.
	 * </p>
	 * 
	 * @param copyright
	 *            The copyright.
	 */
	public void setCopyright(Copyright copyright) {
		this.copyright = copyright;
	}


	@Override
	public ChangeLog getChangeLog() {
		return this.changeLog;
	}
	
	
	/**
	 * <p>
	 * Sets the change log of this package.
	 * </p>
	 * 
	 * @param changeLog
	 *            The change log.
	 */
	public void setChangeLog(ChangeLog changeLog) {
		this.changeLog = changeLog;
	}


}
