/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A {@link Context} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 23.04.2016 by Gerrit Hohl
 */
public class ContextImpl implements Context {
	
	
	/** The warnings. */
	private List<Warning>	warnings;
	/** The lock for the warnings. */
	private ReadWriteLock	warningsLock;


	/**
	 * <p>
	 * Creates a context.
	 * </p>
	 */
	public ContextImpl() {
		super();

		this.warnings = new ArrayList<>();
		this.warningsLock = new ReentrantReadWriteLock();
	}


	@Override
	public void addWarning(Warning warning) {
		if (warning == null)
			throw new IllegalArgumentException("Argument warning is null.");
		
		this.warningsLock.writeLock().lock();
		try {
			this.warnings.add(warning);
		} finally {
			this.warningsLock.writeLock().unlock();
		}
	}


	@Override
	public List<Warning> getWarnings() {
		List<Warning> result;
		
		
		this.warningsLock.readLock().lock();
		try {
			result = new ArrayList<>(this.warnings);
		} finally {
			this.warningsLock.readLock().unlock();
		}
		return result;
	}


}
