/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import net.sourceforge.javadpkg.ChangeLogUrgency;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;
import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;


/**
 * <p>
 * A {@link ChangeLogVersionEntry} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public class ChangeLogVersionEntryImpl implements ChangeLogVersionEntry {
	
	
	/** The name of the package. */
	private PackageName							packageName;
	/** The version. */
	private PackageVersion						version;
	/** The distributions. */
	private List<String>						distributions;
	/** The urgency of the version. */
	private ChangeLogUrgency					urgency;
	/** The details. */
	private List<ChangeLogVersionEntryDetail>	details;
	/** The maintainer. */
	private PackageMaintainer					maintainer;
	/** The date. */
	private Date								date;


	/**
	 * <p>
	 * Creates an entry.
	 * </p>
	 */
	public ChangeLogVersionEntryImpl() {
		super();
		
		this.packageName = null;
		this.version = null;
		this.distributions = new ArrayList<>();
		this.urgency = null;
		this.details = new ArrayList<>();
		this.maintainer = null;
		this.date = null;
	}
	
	
	@Override
	public PackageName getPackage() {
		return this.packageName;
	}
	
	
	/**
	 * <p>
	 * Sets the name of the package.
	 * </p>
	 *
	 * @param packageName
	 *            The name.
	 */
	public void setPackageName(PackageName packageName) {
		this.packageName = packageName;
	}


	@Override
	public PackageVersion getVersion() {
		return this.version;
	}
	
	
	/**
	 * <p>
	 * Sets the version.
	 * </p>
	 *
	 * @param version
	 */
	public void setVersion(PackageVersion version) {
		this.version = version;
	}


	@Override
	public List<String> getDistributions() {
		return (new ArrayList<>(this.distributions));
	}
	
	
	/**
	 * <p>
	 * Sets the distributions.
	 * </p>
	 *
	 * @param distributions
	 *            The distributions.
	 */
	public void setDistributions(List<String> distributions) {
		if (distributions == null) {
			this.distributions = new ArrayList<>();
		} else {
			this.distributions = new ArrayList<>(distributions);
		}
	}


	@Override
	public ChangeLogUrgency getUrgency() {
		return this.urgency;
	}


	/**
	 * <p>
	 * Sets the urgency.
	 * </p>
	 *
	 * @param urgency
	 *            The urgency.
	 */
	public void setUrgency(ChangeLogUrgency urgency) {
		this.urgency = urgency;
	}


	@Override
	public List<ChangeLogVersionEntryDetail> getDetails() {
		return (new ArrayList<>(this.details));
	}


	/**
	 * <p>
	 * Sets the details.
	 * </p>
	 *
	 * @param details
	 *            The details.
	 */
	public void setDetails(List<ChangeLogVersionEntryDetail> details) {
		if (details == null) {
			this.details = new ArrayList<>();
		} else {
			this.details = new ArrayList<>(details);
		}
	}


	/**
	 * <p>
	 * Adds a detail.
	 * </p>
	 * 
	 * @param detail
	 *            The detail.
	 * @throws IllegalArgumentException
	 *             If the detail is <code>null</code>.
	 */
	public void addDetail(ChangeLogVersionEntryDetail detail) {
		if (detail == null)
			throw new IllegalArgumentException("Argument detail is null.");
		
		this.details.add(detail);
	}


	@Override
	public PackageMaintainer getMaintainer() {
		return this.maintainer;
	}
	
	
	/**
	 * <p>
	 * Sets the maintainer.
	 * </p>
	 *
	 * @param maintainer
	 *            The maintainer.
	 */
	public void setMaintainer(PackageMaintainer maintainer) {
		this.maintainer = maintainer;
	}


	@Override
	public Date getDate() {
		return this.date;
	}
	
	
	/**
	 * <p>
	 * Sets the date,
	 * </p>
	 *
	 * @param date
	 *            The date.
	 */
	public void setDate(Date date) {
		this.date = date;
	}


}
