/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.Map;
import java.util.TreeMap;

import net.sourceforge.javadpkg.ChangeLogUrgency;
import net.sourceforge.javadpkg.ChangeLogUrgencyParser;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;


/**
 * <p>
 * A {@link ChangeLogUrgencyParser} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public class ChangeLogUrgencyParserImpl implements ChangeLogUrgencyParser {
	
	
	/** The urgency. */
	private Map<String, ChangeLogUrgency> urgency;
	
	
	/**
	 * <p>
	 * Creates a parser.
	 * </p>
	 */
	public ChangeLogUrgencyParserImpl() {
		super();
		
		this.urgency = new TreeMap<>();
		this.addUrgency("low");
		this.addUrgency("medium");
		this.addUrgency("high");
		this.addUrgency("emergency");
		this.addUrgency("critical");
	}
	
	
	/**
	 * <p>
	 * Adds an urgency.
	 * </p>
	 *
	 * @param text
	 *            The text.
	 */
	private void addUrgency(String text) {
		this.urgency.put(text.toLowerCase(), new ChangeLogUrgencyImpl(text));
	}


	@Override
	public ChangeLogUrgency parseChangeLogUrgency(String value, Context context) throws ParseException {
		ChangeLogUrgency urgency;
		
		
		if (value == null)
			throw new IllegalArgumentException("Argument value is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
		
		urgency = this.urgency.get(value.toLowerCase());
		if (urgency == null) {
			urgency = new ChangeLogUrgencyImpl(value);
			context.addWarning(new ChangeLogUrgencyUnsupportedWarning(value));
		}
		
		return urgency;
	}
	
	
	/* **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 */
	
	
	/**
	 * <p>
	 * The {@link ChangeLogUrgency} implementation of this clas.
	 * </p>
	 *
	 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
	 * @version <b>1.0</b>, 06.05.2016 by Gerrit Hohl
	 */
	private class ChangeLogUrgencyImpl implements ChangeLogUrgency {
		
		
		/** The text. */
		private String text;


		/**
		 * <p>
		 * Creates an urgency.
		 * </p>
		 *
		 * @param text
		 *            The text.
		 */
		public ChangeLogUrgencyImpl(String text) {
			super();
			
			this.text = text;
		}
		
		
		@Override
		public String getText() {
			return this.text;
		}


	}


}
