/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;


/**
 * <p>
 * A {@link ChangeLog} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public class ChangeLogImpl implements ChangeLog {
	
	
	/** The entries. */
	private List<ChangeLogVersionEntry> entries;
	
	
	/**
	 * <p>
	 * Creates a change log.
	 * </p>
	 */
	public ChangeLogImpl() {
		super();
		
		this.entries = new ArrayList<>();
	}
	
	
	/**
	 * <p>
	 * Add an entry to the change log.
	 * </p>
	 * 
	 * @param entry
	 *            The entry.
	 * @throws IllegalArgumentException
	 *             If the entry is <code>null</code>.
	 */
	public void addEntry(ChangeLogVersionEntry entry) {
		if (entry == null)
			throw new IllegalArgumentException("Argument entry is null.");
		
		this.entries.add(entry);
	}
	
	
	@Override
	public List<ChangeLogVersionEntry> getEntries() {
		return (new ArrayList<>(this.entries));
	}
	
	
}
