/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.Map;
import java.util.TreeMap;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Section;
import net.sourceforge.javadpkg.control.SectionParser;


/**
 * <p>
 * A {@link SectionParser} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 01.01.2016 by Gerrit Hohl
 */
public class SectionParserImpl implements SectionParser {


	/** The sections. */
	private Map<String, Section> sections;


	/**
	 * <p>
	 * Creates a parser.
	 * </p>
	 */
	public SectionParserImpl() {
		super();
		
		this.sections = new TreeMap<>();
		this.addSection("admin");
		this.addSection("contrib/utils");
		this.addSection("comm");
		this.addSection("database");
		this.addSection("devel");
		this.addSection("doc");
		this.addSection("editors");
		this.addSection("fonts");
		this.addSection("gnome");
		this.addSection("graphics");
		this.addSection("httpd");
		this.addSection("interpreters");
		this.addSection("introspection");
		this.addSection("java");
		this.addSection("kernel");
		this.addSection("libdevel");
		this.addSection("libs");
		this.addSection("localization");
		this.addSection("mail");
		this.addSection("math");
		this.addSection("metapackages");
		this.addSection("misc");
		this.addSection("net");
		this.addSection("non-free/misc");
		this.addSection("oldlibs");
		this.addSection("otherosfs");
		this.addSection("perl");
		this.addSection("php");
		this.addSection("python");
		this.addSection("science");
		this.addSection("shells");
		this.addSection("sound");
		this.addSection("text");
		this.addSection("utils");
		this.addSection("vcs");
		this.addSection("web");
		this.addSection("x11");
		this.addSection("zope");
	}
	
	
	/**
	 * <p>
	 * Adds a section to the internal map.
	 * </p>
	 *
	 * @param name
	 *            The name of the section.
	 */
	private void addSection(String name) {
		this.sections.put(name, new SectionImpl(name));
	}


	@Override
	public Section parseSection(String value, Context context) throws ParseException {
		Section section;
		
		
		if (value == null)
			throw new IllegalArgumentException("Argument value is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
			
		section = this.sections.get(value);
		if (section == null) {
			context.addWarning(new SectionUnsupportedWarning(value));
			section = new SectionImpl(value);
		}
		
		return section;
	}
	
	
	/* **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 */
	
	
	/**
	 * <p>
	 * The {@link Section} implementation of this class.
	 * </p>
	 *
	 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
	 * @version <b>1.0</b>, 01.01.2016 by Gerrit Hohl
	 */
	private class SectionImpl implements Section {


		/** The name. */
		private String name;
		
		
		/**
		 * <p>
		 * Creates a section.
		 * </p>
		 *
		 * @param name
		 *            The name.
		 */
		public SectionImpl(String name) {
			super();
			
			this.name = name;
		}


		@Override
		public String getText() {
			return this.name;
		}
		
		
	}


}
