/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning for an unsupported package priority.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 24.04.2016 by Gerrit Hohl
 */
public class PackagePriorityUnsupportedWarning implements Warning {
	
	
	/** The package priority. */
	private String packagePriority;


	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 * 
	 * @param packagePriority
	 *            The package priority.
	 * @throws IllegalArgumentException
	 *             If the package priority is <code>null</code>.
	 */
	public PackagePriorityUnsupportedWarning(String packagePriority) {
		super();

		if (packagePriority == null)
			throw new IllegalArgumentException("Argument packagePriority is null.");
		
		this.packagePriority = packagePriority;
	}
	
	
	@Override
	public String getText() {
		StringBuilder sb;


		sb = new StringBuilder();
		sb.append("Found unsupported package priority |");
		sb.append(this.packagePriority);
		sb.append("|.");

		return sb.toString();
	}


}
