/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Warning;


/**
 * <p>
 * A warning for an multiple architecture property.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 24.04.2016 by Gerrit Hohl
 */
public class PackageMultiArchitectureUnsupportedWarning implements Warning {
	
	
	/** The multiple architecture property. */
	private String multiArchitecture;
	
	
	/**
	 * <p>
	 * Creates a warning.
	 * </p>
	 * 
	 * @param multiArchitecture
	 *            The multiple architecture property.
	 * @throws IllegalArgumentException
	 *             If the multiple architecture property is <code>null</code>.
	 */
	public PackageMultiArchitectureUnsupportedWarning(String multiArchitecture) {
		super();
		
		if (multiArchitecture == null)
			throw new IllegalArgumentException("Argument multiArchitecture is null.");
		
		this.multiArchitecture = multiArchitecture;
	}
	
	
	@Override
	public String getText() {
		StringBuilder sb;
		
		
		sb = new StringBuilder();
		sb.append("Found unsupported multiple architecture property |");
		sb.append(this.multiArchitecture);
		sb.append("|.");
		
		return sb.toString();
	}


}
