/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMaintainerParser;


/**
 * <p>
 * A {@link PackageMaintainerParser} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
 */
public class PackageMaintainerParserImpl implements PackageMaintainerParser {


	/**
	 * <p>
	 * Creates a parser.
	 * </p>
	 */
	public PackageMaintainerParserImpl() {
		super();
	}


	@Override
	public PackageMaintainer parsePackageMaintainer(String value, Context context) throws ParseException {
		PackageMaintainer maintainer;
		String name, address;
		int indexStart;
		
		
		if (value == null)
			throw new IllegalArgumentException("Argument value is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
			
		indexStart = value.indexOf('<');
		if (indexStart == -1)
			throw new ParseException(
					"Can't parse maintainer |" + value + "|: Couldn't find bracket |<| for the start of the e-mail address.");
		if (!value.endsWith(">"))
			throw new ParseException("Can't parse maintainer |" + value
					+ "|: Value doesn't end with bracket |>| for the end of the e-mail address.");
					
		name = value.substring(0, indexStart).trim();
		address = value.substring(indexStart + 1, value.length() - 1);

		maintainer = new PackageMaintainerImpl(name, address);
		return maintainer;
	}
	
	
	/* **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 */
	
	
	/**
	 * <p>
	 * The {@link PackageMaintainer} implementation of this class.
	 * </p>
	 *
	 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
	 * @version <b>1.0</b>, 03.01.2016 by Gerrit Hohl
	 */
	private class PackageMaintainerImpl implements PackageMaintainer {


		/** The name. */
		private String	name;
		/** The address. */
		private String	address;
						
						
		/**
		 * <p>
		 * Creates a package maintainer.
		 * </p>
		 *
		 * @param name
		 *            The name.
		 * @param address
		 *            The address.
		 */
		public PackageMaintainerImpl(String name, String address) {
			super();
			
			this.name = name;
			this.address = address;
		}
		
		
		@Override
		public String getName() {
			return this.name;
		}
		
		
		@Override
		public String getAddress() {
			return this.address;
		}
		
		
	}


}
