/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import java.net.MalformedURLException;
import java.net.URL;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Homepage;
import net.sourceforge.javadpkg.control.HomepageParser;


/**
 * <p>
 * A {@link HomepageParser} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class HomepageParserImpl implements HomepageParser {
	
	
	/**
	 * <p>
	 * Creates a parser.
	 * </p>
	 */
	public HomepageParserImpl() {
		super();
	}


	@Override
	public Homepage parseHomepage(String value, Context context) throws ParseException {
		URL url;
		Homepage homepage;
		
		
		if (value == null)
			throw new IllegalArgumentException("Argument value is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
			
		try {
			url = new URL(value);
		} catch (MalformedURLException e) {
			throw new ParseException("Couldn't parser homepage |" + value + "|: " + e.getMessage(), e);
		}
		homepage = new HomepageImpl(url);
		return homepage;
	}


	/* **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 * **********************************************************************
	 */


	/**
	 * <p>
	 * The {@link Homepage} implementation.
	 * </p>
	 *
	 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
	 * @version <b>1.0</b>, 29.04.2016 by Gerrit Hohl
	 */
	private class HomepageImpl implements Homepage {


		/** The URL. */
		private URL url;


		/**
		 * <p>
		 * Creates a home-page.
		 * </p>
		 * 
		 * @param url
		 *            The URL.
		 */
		public HomepageImpl(URL url) {
			super();
			
			this.url = url;
		}
		
		
		@Override
		public URL getURL() {
			return this.url;
		}
		
		
	}


}
