/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.ArchitectureBuilder;


/**
 * <p>
 * A {@link ArchitectureBuilder} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 28.04.2016 by Gerrit Hohl
 */
public class ArchitectureBuilderImpl implements ArchitectureBuilder {
	
	
	/**
	 * <p>
	 * Creates a builder.
	 * </p>
	 */
	public ArchitectureBuilderImpl() {
		super();
	}
	
	
	@Override
	public String buildArchitecture(Architecture architecture, Context context) throws BuildException {
		String value;


		if (architecture == null)
			throw new IllegalArgumentException("Argument architecture is null.");
		if (context == null)
			throw new IllegalArgumentException("Argument context is null.");
			
		value = architecture.getText();
		return value;
	}
	
	
}
