/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.Homepage;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMultiArchitecture;
import net.sourceforge.javadpkg.control.PackageVersion;


/**
 * <p>
 * An abstract {@link Control} implementation.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public abstract class AbstractControl implements Control {


	/** The source package dependency. */
	private PackageDependency			source;
	/** The version of the package. */
	private PackageVersion				version;
	/** The architecture. */
	private Architecture				architecture;
	/** The multiple architecture property. */
	private PackageMultiArchitecture	multiArchitecture;
	/** The maintainer. */
	private PackageMaintainer			maintainer;
	/** The original maintainer. */
	private PackageMaintainer			originalMaintainer;
	/** The home-page. */
	private Homepage					homepage;
										
										
	/**
	 * <p>
	 * Creates a control.
	 * </p>
	 */
	public AbstractControl() {
		super();

		this.source = null;
		this.version = null;
		this.architecture = null;
		this.multiArchitecture = null;
		this.maintainer = null;
		this.homepage = null;
	}
	
	
	/**
	 * <p>
	 * Creates a control.
	 * </p>
	 *
	 * @param source
	 *            The source package dependency.
	 * @param version
	 *            The version of the package.
	 * @param architecture
	 *            The architecture.
	 * @param multiArchitecture
	 *            The multiple architecture property.
	 * @param maintainer
	 *            The maintainer.
	 * @param homepage
	 *            The home-page.
	 */
	public AbstractControl(PackageDependency source, PackageVersion version, Architecture architecture,
			PackageMultiArchitecture multiArchitecture, PackageMaintainer maintainer, Homepage homepage) {
			
		super();

		this.source = source;
		this.version = version;
		this.architecture = architecture;
		this.multiArchitecture = multiArchitecture;
		this.maintainer = maintainer;
		this.homepage = homepage;
	}
	
	
	@Override
	public PackageDependency getSource() {
		return this.source;
	}
	
	
	/**
	 * <p>
	 * Sets the source package dependency.
	 * </p>
	 *
	 * @param source
	 *            The package dependency.
	 */
	public void setSource(PackageDependency source) {
		this.source = source;
	}
	
	
	@Override
	public PackageVersion getVersion() {
		return this.version;
	}
	
	
	/**
	 * <p>
	 * Sets the version of the package.
	 * </p>
	 *
	 * @param version
	 *            The version.
	 */
	public void setVersion(PackageVersion version) {
		this.version = version;
	}
	
	
	@Override
	public Architecture getArchitecture() {
		return this.architecture;
	}
	
	
	/**
	 * <p>
	 * Sets the architecture.
	 * </p>
	 *
	 * @param architecture
	 *            The architecture.
	 */
	public void setArchitecture(Architecture architecture) {
		this.architecture = architecture;
	}


	@Override
	public PackageMultiArchitecture getMultiArchitecture() {
		return this.multiArchitecture;
	}
	
	
	/**
	 * <p>
	 * Sets the multiple architecture property.
	 * </p>
	 *
	 * @param multiArchitecture
	 *            The multiple architecture property.
	 */
	public void setMultiArchitecture(PackageMultiArchitecture multiArchitecture) {
		this.multiArchitecture = multiArchitecture;
	}
	
	
	@Override
	public PackageMaintainer getMaintainer() {
		return this.maintainer;
	}
	
	
	/**
	 * <p>
	 * Sets the maintainer.
	 * </p>
	 *
	 * @param maintainer
	 *            The maintainer.
	 */
	public void setMaintainer(PackageMaintainer maintainer) {
		this.maintainer = maintainer;
	}
	
	
	@Override
	public PackageMaintainer getOriginalMaintainer() {
		return this.originalMaintainer;
	}


	/**
	 * <p>
	 * Sets the original maintainer.
	 * </p>
	 *
	 * @param originalMaintainer
	 *            The original maintainer.
	 */
	public void setOriginalMaintainer(PackageMaintainer originalMaintainer) {
		this.originalMaintainer = originalMaintainer;
	}
	
	
	@Override
	public Homepage getHomepage() {
		return this.homepage;
	}
	
	
	/**
	 * <p>
	 * Sets the home-page.
	 * </p>
	 *
	 * @param homepage
	 *            The home-page.
	 */
	public void setHomepage(Homepage homepage) {
		this.homepage = homepage;
	}
	
	
}
