/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control;


/**
 * <p>
 * The section specifies an application area into which the package has been
 * classified.
 * </p>
 * <p>
 * See <a href=
 * "https://www.debian.org/doc/debian-policy/ch-archive.html#s-subsections">2.4
 * Sections</a> for further information.
 * </p>
 * 
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 01.01.2016 by Gerrit Hohl
 */
public interface Section {


	/**
	 * <p>
	 * Returns the section as text.
	 * </p>
	 *
	 * @return The section.
	 */
	String getText();
	
	
}
