/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control;


/**
 * <p>
 * The version number of a package.
 * </p>
 * <p>
 * See <a href=
 * "https://www.debian.org/doc/debian-policy/ch-controlfields.html#s-f-Version">
 * 5.6.12 Version</a> for further information.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public interface PackageVersion {


	/**
	 * <p>
	 * Returns the epoch of the version.
	 * </p>
	 * <p>
	 * This is a single (generally small) unsigned integer. It may be omitted,
	 * in which case zero is assumed. If it is omitted then the
	 * <i>upstream_version</i> may not contain any colons.
	 * </p>
	 *
	 * @return The epoch or <code>null</code>, if the version doesn't have any
	 *         epoch.
	 */
	String getEpoch();
	
	
	/**
	 * <p>
	 * Returns the upstream version which is the main part of the version
	 * number.
	 * </p>
	 * <p>
	 * It is usually the version number of the original ("upstream") package
	 * from which the Debian package file has been made, if this is applicable.
	 * </p>
	 *
	 * @return The upstream version.
	 */
	String getUpstreamVersion();
	
	
	/**
	 * <p>
	 * Returns the version of the Debian package based on the upstream version.
	 * </p>
	 *
	 * @return The Debian revision or <code>null</code>, if the version doesn't
	 *         have any Debian revision.
	 */
	String getDebianRevision();


	/**
	 * <p>
	 * Returns the version as text.
	 * </p>
	 * This method returns a textual representation of the version. This
	 * includes the epoch, the upstream version and the Debian revision.
	 * </p>
	 *
	 * @return The name.
	 */
	String getText();
	
	
}
