/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2015 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg.control;


/**
 * <p>
 * The control of a Debian package.
 * </p>
 * <p>
 * See <a href="https://www.debian.org/doc/debian-policy/ch-controlfields.html">
 * Chapter 5 - Control files and their fields</a> for further information.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 31.12.2015 by Gerrit Hohl
 */
public interface Control {
	
	
	/**
	 * <p>
	 * Returns the source package dependency.
	 * </p>
	 * <p>
	 * If the control is the control of a source package this package dependency
	 * contains only the package name.
	 * </p>
	 * <p>
	 * If the control is the control of a binary package this package dependency
	 * is the dependency on the corresponding source packages maybe including a
	 * version.
	 * </p>
	 *
	 * @return The package dependency.
	 */
	PackageDependency getSource();
	
	
	/**
	 * <p>
	 * Returns the version of the package.
	 * </p>
	 *
	 * @return The version.
	 */
	PackageVersion getVersion();
	
	
	/**
	 * <p>
	 * Returns the architecture.
	 * </p>
	 *
	 * @return The architecture.
	 */
	Architecture getArchitecture();


	/**
	 * <p>
	 * Returns the multiple architecture property.
	 * </p>
	 *
	 * @return The multiple architecture property.
	 */
	PackageMultiArchitecture getMultiArchitecture();
	
	
	/**
	 * <p>
	 * Returns the maintainer.
	 * </p>
	 *
	 * @return The maintainer.
	 */
	PackageMaintainer getMaintainer();


	/**
	 * <p>
	 * Returns the original maintainer.
	 * </p>
	 *
	 * @return The original maintainer.
	 */
	PackageMaintainer getOriginalMaintainer();


	/**
	 * <p>
	 * Returns the homepage.
	 * </p>
	 *
	 * @return The homepage.
	 */
	Homepage getHomepage();
	
	
}
