/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.io.IOException;

import net.sourceforge.javadpkg.io.DataTarget;

/**
 * <p>
 * A builder for the symbols.
 * </p>
 * 
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public interface SymbolsBuilder {
	
	
	/**
	 * <p>
	 * Builds the symbols into the target.
	 * </p>
	 * 
	 * @param symbols
	 *            The symbols.
	 * @param target
	 *            The target.
	 * @throws IllegalArgumentException
	 *             If any of the parameters are <code>null</code>.
	 * @throws IOException
	 *             If an I/O error occurs.
	 * @throws BuildException
	 *             If an error occurs during the building.
	 */
	void buildSymbols(Symbols symbols, DataTarget target) throws IOException, BuildException;


}
