/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.nio.charset.Charset;

/**
 * <p>
 * The global constants which are used by all classes of the library.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 02.05.2016 by Gerrit Hohl
 */
public interface GlobalConstants {
	
	
	/**
	 * <p>
	 * The &quot;UTF-8&quot; which is used for reading and writing the control
	 * file.
	 * </p>
	 */
	String	UTF_8			= "UTF-8";
	/** The &quot;UTF-8&quot; character set. */
	Charset	UTF_8_CHARSET	= Charset.forName(UTF_8);
							
							
}
