/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.io.IOException;

import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileMetaData;

/**
 * <p>
 * A handler for information from the parsing process done by the
 * {@link DebianPackageParser}.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 12.05.2016 by Gerrit Hohl
 */
public interface DebianPackageParseHandler {
	
	
	// TODO Add methods for other parts of a Debian package (control, scripts, etc.)


	/**
	 * <p>
	 * Handles a file from the data of a Debian package.
	 * </p>
	 *
	 * @param metaData
	 *            The meta data of the file.
	 * @param source
	 *            The source (if the file is a regular file, not a symbolic link
	 *            and not a directory. See method {@link FileMetaData#isFile()}
	 *            and {@link FileMetaData#isSymbolicLink()}).
	 * @throws IllegalArgumentException
	 *             If file meta data is <code>null</code> or the meta data is
	 *             from a file, but the source is <code>null</code>.
	 * @throws IOException
	 *             If an I/O error occurs.
	 * @throws ParseException
	 *             If an error occurs during the parsing.
	 */
	void handleData(FileMetaData metaData, DataSource source) throws IOException, ParseException;
	
	
}
