/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

/**
 * <p>
 * The constants of the Debian package.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 26.04.2016 by Gerrit Hohl
 */
public interface DebianPackageConstants extends GlobalConstants {
	
	
	/**
	 * <p>
	 * The name of the &quot;debian-binary&quot; file containing the version of
	 * the Debian package structure.
	 * </p>
	 */
	String	DEBIAN_BINARY		= "debian-binary";
	/**
	 * <p>
	 * The name of the file containing the control information of the Debian
	 * package without the extension.
	 * </p>
	 */
	String	CONTROL_NAME		= "control";
	/**
	 * <p>
	 * The prefix of the file containing the control information of the Debian
	 * package.
	 * </p>
	 */
	String	CONTROL_TAR_PREFIX	= CONTROL_NAME + ".tar.";
	/**
	 * <p>
	 * The name of the file containing the content of the Debian package without
	 * the extension.
	 * </p>
	 */
	String	DATA_NAME			= "data";
	/** The prefix of the file containing the content of the Debian package. */
	String	DATA_TAR_PREFIX		= DATA_NAME + ".tar.";

	/** The suffix of a GZIP compressed TAR file. */
	String	TAR_GZIP_SUFFIX		= ".tar.gz";
	/** The suffix of a XZ compressed TAR file. */
	String	TAR_XZ_SUFFIX		= ".tar.xz";
	/** The suffix of a BZIP2 compressed TAR file. */
	String	TAR_BZIP2_SUFFIX	= ".tar.bz2";

	/** The entry for the control file in the control information archive. */
	String	CONTROL_ENTRY		= "control";
	/** The entry for the MD5 sums file in the control information archive. */
	String	MD5SUMS_ENTRY		= "md5sums";
	/**
	 * <p>
	 * The entry for the pre-installation script file in the control information
	 * archive.
	 * </p>
	 */
	String	PREINST_ENTRY		= "preinst";
	/**
	 * <p>
	 * The entry for the post-installation script file in the control
	 * information archive.
	 * </p>
	 */
	String	POSTINST_ENTRY		= "postinst";
	/**
	 * <p>
	 * The entry for the pre-remove script file in the control information
	 * archive.
	 * </p>
	 */
	String	PRERM_ENTRY			= "prerm";
	/**
	 * <p>
	 * The entry for the post-remove script file in the control information
	 * archive.
	 * </p>
	 */
	String	POSTRM_ENTRY		= "postrm";
	/** The entry for the templates file in the control information archive. */
	String	TEMPLATES_ENTRY		= "templates";
	/**
	 * <p>
	 * The entry for the configuration file in the control information archive.
	 * </p>
	 */
	String	CONFIG_ENTRY		= "config";
	/**
	 * <p>
	 * The entry for the configuration files file in the control information
	 * archive.
	 * </p>
	 */
	String	CONFFILES_ENTRY		= "conffiles";
	/**
	 * <p>
	 * The entry for the shared libraries file in the control information
	 * archive.
	 * </p>
	 */
	String	SHLIBS_ENTRY		= "shlibs";
	/** The entry for the symbols file in the control information archive. */
	String	SYMBOLS_ENTRY		= "symbols";
	/** The entry for the triggers file in the control information archive. */
	String	TRIGGERS_ENTRY		= "triggers";
	
	
	/** The user directory. */
	String	USR_PATH			= "/usr/";
	/** The share directory in the user directory. */
	String	USR_SHARE_PATH		= USR_PATH + "share/";
	/** The base of the documentation path. */
	String	DOC_BASE_PATH		= USR_SHARE_PATH + "doc/";
	
	
	/** The group ID for the root group. */
	long	ROOT_GROUP_ID		= 0;
	/** The group name for the root group. */
	String	ROOT_GROUP_NAME		= "root";
	/** The user ID for the root user. */
	long	ROOT_USER_ID		= 0;
	/** The user name for the root user. */
	String	ROOT_USER_NAME		= "root";

	/** The mode (access rights) for a directory. */
	int		DIRECTORY_MODE		= 00755;
	/** The mode (access rights) for a normal file. */
	int		FILE_MODE			= 00644;
	/** The mode (access rights) for a script. */
	int		SCRIPT_MODE			= 00755;


}
