/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.util.Date;
import java.util.List;

import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageVersion;

/**
 * <p>
 * The entry for one version of a Debian package.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 04.05.2016 by Gerrit Hohl
 */
public interface ChangeLogVersionEntry {
	
	
	/**
	 * <p>
	 * Returns the name of the package.
	 * </p>
	 *
	 * @return The name.
	 */
	PackageName getPackage();
	
	
	/**
	 * <p>
	 * Returns the version.
	 * </p>
	 *
	 * @return The version.
	 */
	PackageVersion getVersion();
	
	
	/**
	 * <p>
	 * Returns the distributions.
	 * </p>
	 *
	 * @return The distributions.
	 */
	List<String> getDistributions();


	/**
	 * <p>
	 * Returns the urgency of the version.
	 * </p>
	 *
	 * @return The urgency.
	 */
	ChangeLogUrgency getUrgency();


	/**
	 * <p>
	 * Returns the details.
	 * </p>
	 * 
	 * @return The details.
	 */
	List<ChangeLogVersionEntryDetail> getDetails();


	/**
	 * <p>
	 * Returns the maintainer.
	 * </p>
	 * 
	 * @return The maintainer.
	 */
	PackageMaintainer getMaintainer();


	/**
	 * <p>
	 * Returns the date.
	 * </p>
	 * 
	 * @return The date.
	 */
	Date getDate();
	
	
}
