/*
 * dpkg - Debian Package library and the Debian Package Maven plugin
 * (c) Copyright 2016 Gerrit Hohl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.javadpkg;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

/**
 * <p>
 * The constants for the change log.
 * </p>
 *
 * @author Gerrit Hohl (gerrit-hohl@users.sourceforge.net)
 * @version <b>1.0</b>, 09.05.2016 by Gerrit Hohl
 */
public interface ChangeLogConstants extends GlobalConstants {
	
	
	/** The prefix of the start line of a detail. */
	String		DETAIL_START_PREFIX				= "  * ";
	/** The prefix of another line of a detail. */
	String		DETAIL_LINE_PREFIX				= "    ";

	/** The prefix of the termination line of a version entry. */
	String		TERMINATION_PREFIX				= " -- ";
	/**
	 * <p>
	 * The separator between the maintainer and the timestamp in the last line
	 * of a change log entry.
	 * </p>
	 */
	String		MAINTAINER_TIMESTAMP_SEPARATOR	= "  ";

	/** The format of the timestamp. */
	DateFormat	TIMESTAMP_FORMAT				= new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
	
	
}
