/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileMetaData;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.FileMetaDataImpl;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.store.DataStoreImpl;
import net.sourceforge.javadpkg.store.FileHash;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class DataStoreImplTest
extends AbstractDpkgTest {
    @Test
    public void testDataStoreImpl() {
        Size size;
        DataStoreImpl store = new DataStoreImpl();
        try {
            size = store.getSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: Store couldn't determine size: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((long)0L, (long)size.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)out);){
            store.write(tarOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: Store couldn't write files into archive: " + e.getMessage()));
        }
        byte[] data = out.toByteArray();
        Assert.assertEquals((long)1536L, (long)data.length);
    }

    @Test
    public void testAddDirectoryString() {
        String content;
        DataStoreImpl store = new DataStoreImpl();
        try {
            store.addDirectory(null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory(".");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("./");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addDirectory("/usr");
        store.addDirectory("/var/");
        store.addDirectory("./tmp/");
        try {
            store.addDirectory("/usr");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("/usr/");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("/opt/lib");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addDirectory("/usr/lib");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)out);){
            store.write(tarOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Store couldn't write files into archive: " + e.getMessage()));
        }
        byte[] data = out.toByteArray();
        Assert.assertEquals((long)3584L, (long)data.length);
        try {
            content = this.readTarContent(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't read TAR archive: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((Object)"drwxr-xr-x     0 root         0 root              0 /\ndrwxr-xr-x     0 root         0 root              0 /tmp/\ndrwxr-xr-x     0 root         0 root              0 /usr/\ndrwxr-xr-x     0 root         0 root              0 /usr/lib/\ndrwxr-xr-x     0 root         0 root              0 /var/\n", (Object)content);
    }

    @Test
    public void testAddDirectoryStringLongStringLongStringInt() {
        String content;
        DataStoreImpl store = new DataStoreImpl();
        FileOwnerImpl owner = new FileOwnerImpl(1234L, "group", 4321L, "user");
        FileModeImpl mode = new FileModeImpl(73);
        try {
            store.addDirectory(null, (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("/var", null, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("/var", (FileOwner)owner, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addDirectory("/usr", (FileOwner)new FileOwnerImpl(1234L, "group1", 4321L, "user1"), (FileMode)new FileModeImpl(73));
        store.addDirectory("/var/", (FileOwner)new FileOwnerImpl(2345L, "group2", 5432L, "user2"), (FileMode)new FileModeImpl(146));
        store.addDirectory("./tmp/", (FileOwner)new FileOwnerImpl(3456L, "group3", 6543L, "user3"), (FileMode)new FileModeImpl(219));
        try {
            store.addDirectory("/usr");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("/usr/");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addDirectory("/opt/lib");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addDirectory("/usr/lib", (FileOwner)new FileOwnerImpl(4567L, "group4", 7654L, "user4"), (FileMode)new FileModeImpl(292));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)out);){
            store.write(tarOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Store couldn't write files into archive: " + e.getMessage()));
        }
        byte[] data = out.toByteArray();
        Assert.assertEquals((long)3584L, (long)data.length);
        try {
            content = this.readTarContent(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't read TAR archive: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((Object)"drwxr-xr-x     0 root         0 root              0 /\nd-wx-wx-wx  3456 group3    6543 user3             0 /tmp/\nd--x--x--x  1234 group1    4321 user1             0 /usr/\ndr--r--r--  4567 group4    7654 user4             0 /usr/lib/\nd-w--w--w-  2345 group2    5432 user2             0 /var/\n", (Object)content);
    }

    @Test
    public void testAddFileDataSourceString() {
        String content;
        DataStoreImpl store = new DataStoreImpl();
        DataSource source = AbstractDpkgTest.createSource(524288, "file1");
        try {
            store.addFile(null, "/hello.txt");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, ".");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "./");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "./");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addFile(source, "/hello.txt");
        source = AbstractDpkgTest.createSource(0x100000, "file2");
        try {
            store.addFile(source, "/hello.txt");
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "/var/hello.txt");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addDirectory("/var");
        store.addFile(source, "/var/hello.txt");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)out);){
            store.write(tarOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Store couldn't write files into archive: " + e.getMessage()));
        }
        byte[] data = out.toByteArray();
        Assert.assertEquals((long)1575936L, (long)data.length);
        try {
            content = this.readTarContent(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't read TAR archive: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((Object)"drwxr-xr-x     0 root         0 root              0 /\ndrwxr-xr-x     0 root         0 root              0 /var/\n-rw-r--r--     0 root         0 root        1048576 /var/hello.txt\n-rw-r--r--     0 root         0 root         524288 /hello.txt\n", (Object)content);
    }

    @Test
    public void testAddFileDataSourceStringLongStringLongStringInt() {
        String content;
        DataStoreImpl store = new DataStoreImpl();
        DataSource source = AbstractDpkgTest.createSource(524288, "file1");
        FileOwnerImpl owner = new FileOwnerImpl(1234L, "group1", 4321L, "user1");
        FileModeImpl mode = new FileModeImpl(73);
        try {
            store.addFile(null, "/hello.txt", (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, null, (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "/hello.txt", null, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "/hello.txt", (FileOwner)owner, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "", (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, ".", (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "./", (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "./", (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addFile(source, "/hello.txt", (FileOwner)owner, (FileMode)mode);
        source = AbstractDpkgTest.createSource(0x100000, "file2");
        try {
            store.addFile(source, "/hello.txt", (FileOwner)new FileOwnerImpl(2345L, "group2", 5432L, "user2"), (FileMode)new FileModeImpl(146));
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addFile(source, "/var/hello.txt", (FileOwner)new FileOwnerImpl(2345L, "group2", 5432L, "user2"), (FileMode)new FileModeImpl(146));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addDirectory("/var");
        store.addFile(source, "/var/hello.txt", (FileOwner)new FileOwnerImpl(2345L, "group2", 5432L, "user2"), (FileMode)new FileModeImpl(146));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)out);){
            store.write(tarOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Store couldn't write files into archive: " + e.getMessage()));
        }
        byte[] data = out.toByteArray();
        Assert.assertEquals((long)1575936L, (long)data.length);
        try {
            content = this.readTarContent(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't read TAR archive: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((Object)"drwxr-xr-x     0 root         0 root              0 /\ndrwxr-xr-x     0 root         0 root              0 /var/\n--w--w--w-  2345 group2    5432 user2       1048576 /var/hello.txt\n---x--x--x  1234 group1    4321 user1        524288 /hello.txt\n", (Object)content);
    }

    @Test
    public void testAddSymLink() {
        String content;
        DataStoreImpl store = new DataStoreImpl();
        FileOwnerImpl owner = new FileOwnerImpl(1234L, "group1", 4321L, "user1");
        FileModeImpl mode = new FileModeImpl(73);
        try {
            store.addSymLink(null, "/usr/local/mypackage/myprogram", (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addSymLink("/link", null, (FileOwner)owner, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addSymLink("/link", "/usr/local/mypackage/myprogram", null, (FileMode)mode);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            store.addSymLink("/link", "/usr/local/mypackage/myprogram", (FileOwner)owner, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        store.addSymLink("/link", "/usr/local/mypackage/myprogram", (FileOwner)owner, (FileMode)mode);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)out);){
            store.write(tarOut);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Store couldn't write files into archive: " + e.getMessage()));
        }
        byte[] data = out.toByteArray();
        Assert.assertEquals((long)2048L, (long)data.length);
        try {
            content = this.readTarContent(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't read TAR archive: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((Object)"drwxr-xr-x     0 root         0 root              0 /\nl--x--x--x  1234 group1    4321 user1            -1 /link\n", (Object)content);
    }

    @Test
    public void testExists() {
        DataStoreImpl store = new DataStoreImpl();
        try {
            store.exists(null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)store.exists("/usr/local/myprogram"));
        Assert.assertFalse((boolean)store.exists("/usr/local/myprogram/program"));
        DataSource source = AbstractDpkgTest.createSource(524288, "file1");
        store.addDirectory("/usr");
        store.addDirectory("/usr/local");
        store.addDirectory("/usr/local/myprogram");
        store.addFile(source, "/usr/local/myprogram/program");
    }

    @Test
    public void testGetSize() {
        Size size;
        DataStoreImpl store = new DataStoreImpl();
        try {
            size = store.getSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: Store couldn't determine size: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((long)0L, (long)size.getBytes());
        store.addDirectory("/var");
        store.addDirectory("/usr");
        try {
            size = store.getSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: Store couldn't determine size: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((long)0L, (long)size.getBytes());
        DataSource source = AbstractDpkgTest.createSource(524288, "file1");
        store.addFile(source, "/var/file1");
        source = AbstractDpkgTest.createSource(0x100000, "file2");
        store.addFile(source, "/var/file2");
        try {
            size = store.getSize();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: Store couldn't determine size: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((long)0x180000L, (long)size.getBytes());
    }

    @Test
    public void testCreateMD5FileHashes() {
        List fileHashes;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
            return;
        }
        DataStoreImpl store = new DataStoreImpl();
        try {
            fileHashes = store.createFileHashes(digest);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create file hashes: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)fileHashes);
        Assert.assertEquals((long)0L, (long)fileHashes.size());
        DataSource source = AbstractDpkgTest.createSource(524288, "file1");
        store.addFile(source, "/file1");
        source = AbstractDpkgTest.createSource(0x100000, "file2");
        store.addFile(source, "/file2");
        try {
            fileHashes = store.createFileHashes(digest);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create file hashes: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)fileHashes);
        Assert.assertEquals((long)2L, (long)fileHashes.size());
        FileHash fileHash = (FileHash)fileHashes.get(0);
        Assert.assertEquals((Object)"file1", (Object)fileHash.getName());
        Assert.assertEquals((Object)"/file1", (Object)fileHash.getPath());
        Assert.assertArrayEquals((byte[])new byte[]{89, 7, 21, -112, 9, -99, 33, -35, 67, -104, -106, 89, 35, 56, -65, -107}, (byte[])fileHash.getHash());
        Assert.assertEquals((Object)"59071590099d21dd439896592338bf95", (Object)fileHash.getHashAsHex());
        fileHash = (FileHash)fileHashes.get(1);
        Assert.assertEquals((Object)"file2", (Object)fileHash.getName());
        Assert.assertEquals((Object)"/file2", (Object)fileHash.getPath());
        Assert.assertArrayEquals((byte[])new byte[]{-74, -40, 27, 54, 10, 86, 114, -40, 12, 39, 67, 15, 57, 21, 62, 44}, (byte[])fileHash.getHash());
        Assert.assertEquals((Object)"b6d81b360a5672d80c27430f39153e2c", (Object)fileHash.getHashAsHex());
    }

    private String readTarContent(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        StringBuilder sb = new StringBuilder();
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                FileMetaData file;
                FileOwnerImpl owner = new FileOwnerImpl(entry.getLongGroupId(), entry.getGroupName(), entry.getLongUserId(), entry.getUserName());
                FileModeImpl mode = new FileModeImpl(entry.getMode());
                if (entry.isDirectory()) {
                    file = FileMetaDataImpl.createDirectoryMetaData((String)entry.getName(), (FileOwner)owner, (FileMode)mode, (Date)entry.getLastModifiedDate());
                } else if (entry.isSymbolicLink()) {
                    file = FileMetaDataImpl.createSymbolicLinkMetaData((String)entry.getName(), (String)entry.getLinkName(), (FileOwner)owner, (FileMode)mode, (Date)entry.getLastModifiedDate());
                } else if (entry.isFile()) {
                    file = FileMetaDataImpl.createFileMetaData((String)entry.getName(), (FileOwner)owner, (FileMode)mode, (long)entry.getSize(), (Date)entry.getLastModifiedDate());
                } else {
                    throw new IOException("Entry |" + entry.getName() + "| is not a directory, symbolic link or file.");
                }
                Long groupId = file.getOwner().getGroupId();
                Long userId = file.getOwner().getUserId();
                Long length = file.isDirectory() && file.getLength() < 0L ? Long.valueOf(0L) : Long.valueOf(file.getLength());
                sb.append(String.format("%s %5d %-8s %5d %-8s %10d %s\n", file.getModeAsText(), groupId, file.getOwner().getGroupName(), userId, file.getOwner().getUserName(), length, file.getAbsolutePath()));
            }
        }
        return sb.toString();
    }
}

