/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.replace;

import java.util.HashMap;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.Replacements;
import net.sourceforge.javadpkg.replace.ReplacementsMap;
import net.sourceforge.javadpkg.replace.ReplacerImpl;
import org.junit.Assert;
import org.junit.Test;

public class ReplacerImplTest
extends AbstractDpkgTest {
    @Test
    public void testParameters() {
        ReplacerImpl replacer = new ReplacerImpl();
        ReplacementsMap replacements = new ReplacementsMap();
        ContextImpl context = new ContextImpl();
        try {
            replacer.replace(null, (Replacements)replacements, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            replacer.replace("THISVERSION=\"${deb.version}\"", null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            replacer.replace("THISVERSION=\"${deb.version}\"", (Replacements)replacements, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
    }

    @Test
    public void testReplaceSuccessful() {
        String result;
        ReplacerImpl replacer = new ReplacerImpl();
        ContextImpl context = new ContextImpl();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("deb.version", "1.0.0");
        ReplacementsMap replacements = new ReplacementsMap(variables);
        try {
            result = replacer.replace("THISVERSION=\"${deb.version}\"", (Replacements)replacements, (Context)context);
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"THISVERSION=\"1.0.0\"", (Object)result);
        context = new ContextImpl();
        variables = new HashMap();
        variables.put("link", "/opt/mainfolder");
        variables.put("folder", "/opt/versionfolder-1.0.0");
        replacements = new ReplacementsMap(variables);
        try {
            result = replacer.replace("        ln --force --symbolic ${folder} ${link}", (Replacements)replacements, (Context)context);
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"        ln --force --symbolic /opt/versionfolder-1.0.0 /opt/mainfolder", (Object)result);
    }

    @Test
    public void testReplaceWarning() {
        String result;
        ReplacerImpl replacer = new ReplacerImpl();
        ContextImpl context = new ContextImpl();
        ReplacementsMap replacements = new ReplacementsMap();
        try {
            result = replacer.replace("THISVERSION=\"${deb.version}\"", (Replacements)replacements, (Context)context);
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)1L, (long)warnings.size());
        Warning warning = (Warning)warnings.get(0);
        Assert.assertNotNull((Object)warning);
        Assert.assertEquals((Object)"Found unknown variable |deb.version|. The variable will be ignored and not replaced.", (Object)warning.getText());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"THISVERSION=\"${deb.version}\"", (Object)result);
    }

    @Test
    public void testReplaceError() {
        ReplacerImpl replacer = new ReplacerImpl();
        ContextImpl context = new ContextImpl();
        ReplacementsMap replacements = new ReplacementsMap();
        try {
            replacer.replace("THISVERSION=\"${deb.version\"", (Replacements)replacements, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (ReplacementException replacementException) {
            // empty catch block
        }
    }
}

