/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.util.Date;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.io.FileMetaData;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.FileMetaDataImpl;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import org.junit.Assert;
import org.junit.Test;

public class FileMetaDataImplTest
extends AbstractDpkgTest {
    @Test
    public void testFileMetaDataImplStringStringFileOwnerFileModeDate() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        try {
            FileMetaDataImpl file = new FileMetaDataImpl((String)null, "usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl file = new FileMetaDataImpl("", "usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl file = new FileMetaDataImpl("/", null, (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl file = new FileMetaDataImpl("/", "/", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl file = new FileMetaDataImpl("/", "", null, (FileMode)mode, lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", (FileOwner)owner, null, lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", (FileOwner)owner, (FileMode)mode, null);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    FileMetaDataImpl file = new FileMetaDataImpl("/", "", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                    Assert.assertEquals((Object)"/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"", (Object)file.getName());
                                    Assert.assertEquals((Object)"/", (Object)file.getAbsolutePath());
                                    Assert.assertFalse((boolean)file.isFile());
                                    Assert.assertTrue((boolean)file.isDirectory());
                                    Assert.assertFalse((boolean)file.isSymbolicLink());
                                    Assert.assertNull((Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)-1L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    file = new FileMetaDataImpl("./", "usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                    Assert.assertEquals((Object)"/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"usr", (Object)file.getName());
                                    Assert.assertEquals((Object)"/usr/", (Object)file.getAbsolutePath());
                                    Assert.assertFalse((boolean)file.isFile());
                                    Assert.assertTrue((boolean)file.isDirectory());
                                    Assert.assertFalse((boolean)file.isSymbolicLink());
                                    Assert.assertNull((Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)-1L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    file = new FileMetaDataImpl("usr", "local", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                    Assert.assertEquals((Object)"/usr/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"local", (Object)file.getName());
                                    Assert.assertEquals((Object)"/usr/local/", (Object)file.getAbsolutePath());
                                    Assert.assertFalse((boolean)file.isFile());
                                    Assert.assertTrue((boolean)file.isDirectory());
                                    Assert.assertFalse((boolean)file.isSymbolicLink());
                                    Assert.assertNull((Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)-1L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFileMetaDataImplFileMetaDataStringFileOwnerFileModeDate() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        FileMetaDataImpl parent = new FileMetaDataImpl("/", "", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493), new Date(1463043896603L));
        try {
            FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)null, "usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, null, (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "/", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", null, (FileMode)mode, lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, null, lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, (FileMode)mode, null);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                Assert.assertEquals((Object)"/", (Object)file.getPath());
                                Assert.assertEquals((Object)"usr", (Object)file.getName());
                                Assert.assertEquals((Object)"/usr/", (Object)file.getAbsolutePath());
                                Assert.assertFalse((boolean)file.isFile());
                                Assert.assertTrue((boolean)file.isDirectory());
                                Assert.assertFalse((boolean)file.isSymbolicLink());
                                Assert.assertNull((Object)file.getTargetPath());
                                Assert.assertSame((Object)owner, (Object)file.getOwner());
                                Assert.assertSame((Object)mode, (Object)file.getMode());
                                Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                                Assert.assertEquals((long)-1L, (long)file.getLength());
                                Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                parent = file;
                                file = new FileMetaDataImpl((FileMetaData)parent, "local", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                Assert.assertEquals((Object)"/usr/", (Object)file.getPath());
                                Assert.assertEquals((Object)"local", (Object)file.getName());
                                Assert.assertEquals((Object)"/usr/local/", (Object)file.getAbsolutePath());
                                Assert.assertFalse((boolean)file.isFile());
                                Assert.assertTrue((boolean)file.isDirectory());
                                Assert.assertFalse((boolean)file.isSymbolicLink());
                                Assert.assertNull((Object)file.getTargetPath());
                                Assert.assertSame((Object)owner, (Object)file.getOwner());
                                Assert.assertSame((Object)mode, (Object)file.getMode());
                                Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                                Assert.assertEquals((long)-1L, (long)file.getLength());
                                Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFileMetaDataImplStringStringFileOwnerFileModeLongDate() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        try {
            FileMetaDataImpl file = new FileMetaDataImpl((String)null, "usr", (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl file = new FileMetaDataImpl("", "usr", (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl file = new FileMetaDataImpl("/", null, (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl file = new FileMetaDataImpl("/", "/", (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", null, (FileMode)mode, 0L, lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", (FileOwner)owner, null, 0L, lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", (FileOwner)owner, null, -2L, lastModifiedDate);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    try {
                                        FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", (FileOwner)owner, (FileMode)mode, 0L, null);
                                        Assert.fail((String)"Expected an exception, but none was thrown.");
                                        return;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException8) {
                                        FileMetaDataImpl file = new FileMetaDataImpl("./usr/local/mypackage", "myprogram", (FileOwner)owner, (FileMode)mode, 12345L, lastModifiedDate);
                                        Assert.assertEquals((Object)"/usr/local/mypackage/", (Object)file.getPath());
                                        Assert.assertEquals((Object)"myprogram", (Object)file.getName());
                                        Assert.assertEquals((Object)"/usr/local/mypackage/myprogram", (Object)file.getAbsolutePath());
                                        Assert.assertTrue((boolean)file.isFile());
                                        Assert.assertFalse((boolean)file.isDirectory());
                                        Assert.assertFalse((boolean)file.isSymbolicLink());
                                        Assert.assertNull((Object)file.getTargetPath());
                                        Assert.assertSame((Object)owner, (Object)file.getOwner());
                                        Assert.assertSame((Object)mode, (Object)file.getMode());
                                        Assert.assertEquals((Object)"-rwxr-xr-x", (Object)file.getModeAsText());
                                        Assert.assertEquals((long)12345L, (long)file.getLength());
                                        Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                        mode = new FileModeImpl(420);
                                        file = new FileMetaDataImpl("usr/local/mypackage/", "myprogram", (FileOwner)owner, (FileMode)mode, 12345L, lastModifiedDate);
                                        Assert.assertEquals((Object)"/usr/local/mypackage/", (Object)file.getPath());
                                        Assert.assertEquals((Object)"myprogram", (Object)file.getName());
                                        Assert.assertEquals((Object)"/usr/local/mypackage/myprogram", (Object)file.getAbsolutePath());
                                        Assert.assertTrue((boolean)file.isFile());
                                        Assert.assertFalse((boolean)file.isDirectory());
                                        Assert.assertFalse((boolean)file.isSymbolicLink());
                                        Assert.assertNull((Object)file.getTargetPath());
                                        Assert.assertSame((Object)owner, (Object)file.getOwner());
                                        Assert.assertSame((Object)mode, (Object)file.getMode());
                                        Assert.assertEquals((Object)"-rw-r--r--", (Object)file.getModeAsText());
                                        Assert.assertEquals((long)12345L, (long)file.getLength());
                                        Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFileMetaDataImplFileMetaDataStringFileOwnerFileModeLongDate() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        FileMetaDataImpl parent = new FileMetaDataImpl("/usr/local/", "mypackage", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493), new Date(1463043896603L));
        try {
            FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)null, "usr", (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, null, (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "/", (FileOwner)owner, (FileMode)mode, 0L, lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", null, (FileMode)mode, 0L, lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, null, 0L, lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, null, -2L, lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, (FileMode)mode, 0L, null);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "myprogram", (FileOwner)owner, (FileMode)mode, 12345L, lastModifiedDate);
                                    Assert.assertEquals((Object)"/usr/local/mypackage/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"myprogram", (Object)file.getName());
                                    Assert.assertEquals((Object)"/usr/local/mypackage/myprogram", (Object)file.getAbsolutePath());
                                    Assert.assertTrue((boolean)file.isFile());
                                    Assert.assertFalse((boolean)file.isDirectory());
                                    Assert.assertFalse((boolean)file.isSymbolicLink());
                                    Assert.assertNull((Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"-rwxr-xr-x", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)12345L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    mode = new FileModeImpl(420);
                                    file = new FileMetaDataImpl((FileMetaData)parent, "myprogram", (FileOwner)owner, (FileMode)mode, 12345L, lastModifiedDate);
                                    Assert.assertEquals((Object)"/usr/local/mypackage/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"myprogram", (Object)file.getName());
                                    Assert.assertEquals((Object)"/usr/local/mypackage/myprogram", (Object)file.getAbsolutePath());
                                    Assert.assertTrue((boolean)file.isFile());
                                    Assert.assertFalse((boolean)file.isDirectory());
                                    Assert.assertFalse((boolean)file.isSymbolicLink());
                                    Assert.assertNull((Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"-rw-r--r--", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)12345L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFileMetaDataImplStringStringStringFileOwnerFileModeDate() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        try {
            FileMetaDataImpl file = new FileMetaDataImpl((String)null, "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl file = new FileMetaDataImpl("", "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl file = new FileMetaDataImpl("/", null, "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl file = new FileMetaDataImpl("/", "/", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl file = new FileMetaDataImpl("/", "/", null, (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaDataImpl file = new FileMetaDataImpl("/", "/", "", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaDataImpl file = new FileMetaDataImpl("/", "", "/mnt/usr", null, (FileMode)mode, lastModifiedDate);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    try {
                                        FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", "/mnt/usr", (FileOwner)owner, null, lastModifiedDate);
                                        Assert.fail((String)"Expected an exception, but none was thrown.");
                                        return;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException8) {
                                        try {
                                            FileMetaDataImpl file = new FileMetaDataImpl("/", "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, null);
                                            Assert.fail((String)"Expected an exception, but none was thrown.");
                                            return;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException9) {
                                            FileMetaDataImpl file = new FileMetaDataImpl("./", "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                            Assert.assertEquals((Object)"/", (Object)file.getPath());
                                            Assert.assertEquals((Object)"usr", (Object)file.getName());
                                            Assert.assertEquals((Object)"/usr", (Object)file.getAbsolutePath());
                                            Assert.assertTrue((boolean)file.isFile());
                                            Assert.assertFalse((boolean)file.isDirectory());
                                            Assert.assertTrue((boolean)file.isSymbolicLink());
                                            Assert.assertEquals((Object)"/mnt/usr", (Object)file.getTargetPath());
                                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                                            Assert.assertSame((Object)mode, (Object)file.getMode());
                                            Assert.assertEquals((Object)"lrwxr-xr-x", (Object)file.getModeAsText());
                                            Assert.assertEquals((long)-1L, (long)file.getLength());
                                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                            file = new FileMetaDataImpl("usr", "local", "/mnt/usr/local", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                            Assert.assertEquals((Object)"/usr/", (Object)file.getPath());
                                            Assert.assertEquals((Object)"local", (Object)file.getName());
                                            Assert.assertEquals((Object)"/usr/local", (Object)file.getAbsolutePath());
                                            Assert.assertTrue((boolean)file.isFile());
                                            Assert.assertFalse((boolean)file.isDirectory());
                                            Assert.assertTrue((boolean)file.isSymbolicLink());
                                            Assert.assertEquals((Object)"/mnt/usr/local", (Object)file.getTargetPath());
                                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                                            Assert.assertSame((Object)mode, (Object)file.getMode());
                                            Assert.assertEquals((Object)"lrwxr-xr-x", (Object)file.getModeAsText());
                                            Assert.assertEquals((long)-1L, (long)file.getLength());
                                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testFileMetaDataImplFileMetaDataStringStringFileOwnerFileModeDate2() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        FileMetaDataImpl parent = new FileMetaDataImpl("/", "", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493), new Date(1463043896603L));
        try {
            FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)null, "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, null, "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "/", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", null, (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", "", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", "/mnt/usr", null, (FileMode)mode, lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", "/mnt/usr", (FileOwner)owner, null, lastModifiedDate);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    try {
                                        FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, null);
                                        Assert.fail((String)"Expected an exception, but none was thrown.");
                                        return;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException8) {
                                        FileMetaDataImpl file = new FileMetaDataImpl((FileMetaData)parent, "usr", "/mnt/usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                        Assert.assertEquals((Object)"/", (Object)file.getPath());
                                        Assert.assertEquals((Object)"usr", (Object)file.getName());
                                        Assert.assertEquals((Object)"/usr", (Object)file.getAbsolutePath());
                                        Assert.assertTrue((boolean)file.isFile());
                                        Assert.assertFalse((boolean)file.isDirectory());
                                        Assert.assertTrue((boolean)file.isSymbolicLink());
                                        Assert.assertEquals((Object)"/mnt/usr", (Object)file.getTargetPath());
                                        Assert.assertSame((Object)owner, (Object)file.getOwner());
                                        Assert.assertSame((Object)mode, (Object)file.getMode());
                                        Assert.assertEquals((Object)"lrwxr-xr-x", (Object)file.getModeAsText());
                                        Assert.assertEquals((long)-1L, (long)file.getLength());
                                        Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                        parent = new FileMetaDataImpl((FileMetaData)parent, "usr", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                        file = new FileMetaDataImpl((FileMetaData)parent, "local", "/mnt/usr/local", (FileOwner)owner, (FileMode)mode, lastModifiedDate);
                                        Assert.assertEquals((Object)"/usr/", (Object)file.getPath());
                                        Assert.assertEquals((Object)"local", (Object)file.getName());
                                        Assert.assertEquals((Object)"/usr/local", (Object)file.getAbsolutePath());
                                        Assert.assertTrue((boolean)file.isFile());
                                        Assert.assertFalse((boolean)file.isDirectory());
                                        Assert.assertTrue((boolean)file.isSymbolicLink());
                                        Assert.assertEquals((Object)"/mnt/usr/local", (Object)file.getTargetPath());
                                        Assert.assertSame((Object)owner, (Object)file.getOwner());
                                        Assert.assertSame((Object)mode, (Object)file.getMode());
                                        Assert.assertEquals((Object)"lrwxr-xr-x", (Object)file.getModeAsText());
                                        Assert.assertEquals((long)-1L, (long)file.getLength());
                                        Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testCreateDirectoryMetaData() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        try {
            FileMetaDataImpl.createDirectoryMetaData(null, (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaDataImpl.createDirectoryMetaData((String)"", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaDataImpl.createDirectoryMetaData((String)"/", null, (FileMode)mode, (Date)lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaDataImpl.createDirectoryMetaData((String)"/", (FileOwner)owner, null, (Date)lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaDataImpl.createDirectoryMetaData((String)"/", (FileOwner)owner, (FileMode)mode, null);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            FileMetaData file = FileMetaDataImpl.createDirectoryMetaData((String)"/", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.assertEquals((Object)"/", (Object)file.getPath());
                            Assert.assertEquals((Object)"", (Object)file.getName());
                            Assert.assertEquals((Object)"/", (Object)file.getAbsolutePath());
                            Assert.assertFalse((boolean)file.isFile());
                            Assert.assertTrue((boolean)file.isDirectory());
                            Assert.assertFalse((boolean)file.isSymbolicLink());
                            Assert.assertNull((Object)file.getTargetPath());
                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                            Assert.assertSame((Object)mode, (Object)file.getMode());
                            Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                            Assert.assertEquals((long)-1L, (long)file.getLength());
                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                            file = FileMetaDataImpl.createDirectoryMetaData((String)"./usr/", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.assertEquals((Object)"/", (Object)file.getPath());
                            Assert.assertEquals((Object)"usr", (Object)file.getName());
                            Assert.assertEquals((Object)"/usr/", (Object)file.getAbsolutePath());
                            Assert.assertFalse((boolean)file.isFile());
                            Assert.assertTrue((boolean)file.isDirectory());
                            Assert.assertFalse((boolean)file.isSymbolicLink());
                            Assert.assertNull((Object)file.getTargetPath());
                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                            Assert.assertSame((Object)mode, (Object)file.getMode());
                            Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                            Assert.assertEquals((long)-1L, (long)file.getLength());
                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                            file = FileMetaDataImpl.createDirectoryMetaData((String)"/usr/", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.assertEquals((Object)"/", (Object)file.getPath());
                            Assert.assertEquals((Object)"usr", (Object)file.getName());
                            Assert.assertEquals((Object)"/usr/", (Object)file.getAbsolutePath());
                            Assert.assertFalse((boolean)file.isFile());
                            Assert.assertTrue((boolean)file.isDirectory());
                            Assert.assertFalse((boolean)file.isSymbolicLink());
                            Assert.assertNull((Object)file.getTargetPath());
                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                            Assert.assertSame((Object)mode, (Object)file.getMode());
                            Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                            Assert.assertEquals((long)-1L, (long)file.getLength());
                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                            file = FileMetaDataImpl.createDirectoryMetaData((String)"usr/", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.assertEquals((Object)"/", (Object)file.getPath());
                            Assert.assertEquals((Object)"usr", (Object)file.getName());
                            Assert.assertEquals((Object)"/usr/", (Object)file.getAbsolutePath());
                            Assert.assertFalse((boolean)file.isFile());
                            Assert.assertTrue((boolean)file.isDirectory());
                            Assert.assertFalse((boolean)file.isSymbolicLink());
                            Assert.assertNull((Object)file.getTargetPath());
                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                            Assert.assertSame((Object)mode, (Object)file.getMode());
                            Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                            Assert.assertEquals((long)-1L, (long)file.getLength());
                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                            file = FileMetaDataImpl.createDirectoryMetaData((String)"/usr", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.assertEquals((Object)"/", (Object)file.getPath());
                            Assert.assertEquals((Object)"usr", (Object)file.getName());
                            Assert.assertEquals((Object)"/usr/", (Object)file.getAbsolutePath());
                            Assert.assertFalse((boolean)file.isFile());
                            Assert.assertTrue((boolean)file.isDirectory());
                            Assert.assertFalse((boolean)file.isSymbolicLink());
                            Assert.assertNull((Object)file.getTargetPath());
                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                            Assert.assertSame((Object)mode, (Object)file.getMode());
                            Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                            Assert.assertEquals((long)-1L, (long)file.getLength());
                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                            file = FileMetaDataImpl.createDirectoryMetaData((String)"/usr/local/", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.assertEquals((Object)"/usr/", (Object)file.getPath());
                            Assert.assertEquals((Object)"local", (Object)file.getName());
                            Assert.assertEquals((Object)"/usr/local/", (Object)file.getAbsolutePath());
                            Assert.assertFalse((boolean)file.isFile());
                            Assert.assertTrue((boolean)file.isDirectory());
                            Assert.assertFalse((boolean)file.isSymbolicLink());
                            Assert.assertNull((Object)file.getTargetPath());
                            Assert.assertSame((Object)owner, (Object)file.getOwner());
                            Assert.assertSame((Object)mode, (Object)file.getMode());
                            Assert.assertEquals((Object)"drwxr-xr-x", (Object)file.getModeAsText());
                            Assert.assertEquals((long)-1L, (long)file.getLength());
                            Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                            return;
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testCreateFileMetaData() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        try {
            FileMetaData file = FileMetaDataImpl.createFileMetaData(null, (FileOwner)owner, (FileMode)mode, (long)0L, (Date)lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"", (FileOwner)owner, (FileMode)mode, (long)0L, (Date)lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"/usr/", (FileOwner)owner, (FileMode)mode, (long)0L, (Date)lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"/usr/", (FileOwner)owner, (FileMode)mode, (long)0L, (Date)lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"/usr/local/mypackage/myprogram", null, (FileMode)mode, (long)0L, (Date)lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"/usr/local/mypackage/myprogram", (FileOwner)owner, null, (long)-2L, (Date)lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"/usr/local/mypackage/myprogram", (FileOwner)owner, (FileMode)mode, (long)0L, null);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    FileMetaData file = FileMetaDataImpl.createFileMetaData((String)"/usr/local/mypackage/myprogram", (FileOwner)owner, (FileMode)mode, (long)12345L, (Date)lastModifiedDate);
                                    Assert.assertEquals((Object)"/usr/local/mypackage/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"myprogram", (Object)file.getName());
                                    Assert.assertEquals((Object)"/usr/local/mypackage/myprogram", (Object)file.getAbsolutePath());
                                    Assert.assertTrue((boolean)file.isFile());
                                    Assert.assertFalse((boolean)file.isDirectory());
                                    Assert.assertFalse((boolean)file.isSymbolicLink());
                                    Assert.assertNull((Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"-rwxr-xr-x", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)12345L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testCreateSymbolicLinkMetaData() {
        FileOwnerImpl owner = new FileOwnerImpl(0L, "root", 0L, "root");
        FileModeImpl mode = new FileModeImpl(493);
        Date lastModifiedDate = new Date(1463043896603L);
        try {
            FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData(null, (String)"/mnt/usr/local", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"", (String)"/mnt/usr/local", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                Assert.fail((String)"Expected an exception, but none was thrown.");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"/usr/local", null, (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                    Assert.fail((String)"Expected an exception, but none was thrown.");
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"/usr/local", (String)"", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                        Assert.fail((String)"Expected an exception, but none was thrown.");
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"/usr/local", (String)"/mnt/usr/local", null, (FileMode)mode, (Date)lastModifiedDate);
                            Assert.fail((String)"Expected an exception, but none was thrown.");
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            try {
                                FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"/usr/local", (String)"/mnt/usr/local", (FileOwner)owner, null, (Date)lastModifiedDate);
                                Assert.fail((String)"Expected an exception, but none was thrown.");
                                return;
                            }
                            catch (IllegalArgumentException illegalArgumentException6) {
                                try {
                                    FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"/usr/local", (String)"/mnt/usr/local", (FileOwner)owner, (FileMode)mode, null);
                                    Assert.fail((String)"Expected an exception, but none was thrown.");
                                    return;
                                }
                                catch (IllegalArgumentException illegalArgumentException7) {
                                    FileMetaData file = FileMetaDataImpl.createSymbolicLinkMetaData((String)"/usr/local", (String)"/mnt/usr/local", (FileOwner)owner, (FileMode)mode, (Date)lastModifiedDate);
                                    Assert.assertEquals((Object)"/usr/", (Object)file.getPath());
                                    Assert.assertEquals((Object)"local", (Object)file.getName());
                                    Assert.assertEquals((Object)"/usr/local", (Object)file.getAbsolutePath());
                                    Assert.assertTrue((boolean)file.isFile());
                                    Assert.assertFalse((boolean)file.isDirectory());
                                    Assert.assertTrue((boolean)file.isSymbolicLink());
                                    Assert.assertEquals((Object)"/mnt/usr/local", (Object)file.getTargetPath());
                                    Assert.assertSame((Object)owner, (Object)file.getOwner());
                                    Assert.assertSame((Object)mode, (Object)file.getMode());
                                    Assert.assertEquals((Object)"lrwxr-xr-x", (Object)file.getModeAsText());
                                    Assert.assertEquals((long)-1L, (long)file.getLength());
                                    Assert.assertSame((Object)lastModifiedDate, (Object)file.getLastModifiedDate());
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

