/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.Streams;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import org.junit.Assert;
import org.junit.Test;

public class StreamsTest
extends AbstractDpkgTest {
    @Test
    public void testCompressGzip() {
        int len;
        ByteArrayInputStream in = new ByteArrayInputStream("Hello World!".getBytes());
        DataStreamSource source = new DataStreamSource((InputStream)in, "raw", false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataStreamTarget target = new DataStreamTarget((OutputStream)out, "gzip", false);
        try {
            Streams.compressGzip(null, (DataTarget)target, (int)9);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            Streams.compressGzip((DataSource)source, null, (int)9);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            Streams.compressGzip((DataSource)source, (DataTarget)target, (int)-2);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            Streams.compressGzip((DataSource)source, (DataTarget)target, (int)10);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            Streams.compressGzip((DataSource)source, (DataTarget)target, (int)9);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        in = new ByteArrayInputStream(out.toByteArray());
        byte[] buffer = new byte[65536];
        try (GZIPInputStream gzipIn = new GZIPInputStream(in);){
            len = gzipIn.read(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        Assert.assertEquals((long)12L, (long)len);
        Assert.assertEquals((Object)"Hello World!", (Object)new String(buffer, 0, len));
    }
}

