/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.ScriptImpl;
import net.sourceforge.javadpkg.impl.ScriptVariableReplacerImpl;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.Replacements;
import net.sourceforge.javadpkg.replace.ReplacementsMap;
import org.junit.Assert;
import org.junit.Test;

public class ScriptVariableReplacerImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        Script scriptReplaced;
        ScriptVariableReplacerImpl replacer = new ScriptVariableReplacerImpl();
        ScriptImpl script = new ScriptImpl();
        ReplacementsMap replacements = new ReplacementsMap();
        ContextImpl context = new ContextImpl();
        try {
            replacer.replaceScriptVariables(null, (Replacements)replacements, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            replacer.replaceScriptVariables((Script)script, null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            replacer.replaceScriptVariables((Script)script, (Replacements)replacements, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        script = new ScriptImpl(Arrays.asList("#!/bin/sh", "# --- Enable error detection. ---", "set -e", "", "# --- Set version of this package ---", "THISVERSION=\"${deb.version}\"", "", "echo Pre-installation script version $THISVERSION", "echo \"   Parameters                  : $@\"", "echo \"   Option                      : $1\"", "echo \"   Currently installed version : $2\"", "echo \"   Version of this package     : $THISVERSION\"", "", "case \"$1\" in", "    install)", "        echo \"   No tasks.\"", "        ;;", "    upgrade)", "        echo \"   No tasks.\"", "        ;;", "    *)", "        echo \"   Option $1 not supported by this script.\"", "        ;;", "esac", ""));
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("deb.version", "1.0.0");
        replacements = new ReplacementsMap(variables);
        try {
            scriptReplaced = replacer.replaceScriptVariables((Script)script, (Replacements)replacements, (Context)context);
        }
        catch (ReplacementException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"#!/bin/sh\n# --- Enable error detection. ---\nset -e\n\n# --- Set version of this package ---\nTHISVERSION=\"${deb.version}\"\n\necho Pre-installation script version $THISVERSION\necho \"   Parameters                  : $@\"\necho \"   Option                      : $1\"\necho \"   Currently installed version : $2\"\necho \"   Version of this package     : $THISVERSION\"\n\ncase \"$1\" in\n    install)\n        echo \"   No tasks.\"\n        ;;\n    upgrade)\n        echo \"   No tasks.\"\n        ;;\n    *)\n        echo \"   Option $1 not supported by this script.\"\n        ;;\nesac\n", (Object)script.getText());
        Assert.assertNotNull((Object)scriptReplaced);
        Assert.assertEquals((Object)"#!/bin/sh\n# --- Enable error detection. ---\nset -e\n\n# --- Set version of this package ---\nTHISVERSION=\"1.0.0\"\n\necho Pre-installation script version $THISVERSION\necho \"   Parameters                  : $@\"\necho \"   Option                      : $1\"\necho \"   Currently installed version : $2\"\necho \"   Version of this package     : $THISVERSION\"\n\ncase \"$1\" in\n    install)\n        echo \"   No tasks.\"\n        ;;\n    upgrade)\n        echo \"   No tasks.\"\n        ;;\n    *)\n        echo \"   Option $1 not supported by this script.\"\n        ;;\nesac\n", (Object)scriptReplaced.getText());
    }
}

