/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.ScriptParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class ScriptParserImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        Script script;
        ScriptParserImpl parser = new ScriptParserImpl();
        DataSource source = ScriptParserImplTest.createSource(Arrays.asList("#!/bin/sh", "# --- Enable error detection. ---", "set -e", "", "# --- Set version of this package ---", "THISVERSION=\"${deb.version}\"", "", "echo Pre-installation script version $THISVERSION", "echo \"   Parameters                  : $@\"", "echo \"   Option                      : $1\"", "echo \"   Currently installed version : $2\"", "echo \"   Version of this package     : $THISVERSION\"", "", "case \"$1\" in", "    install)", "        echo \"   No tasks.\"", "        ;;", "    upgrade)", "        echo \"   No tasks.\"", "        ;;", "    *)", "        echo \"   Option $1 not supported by this script.\"", "        ;;", "esac", ""), "preinst");
        ContextImpl context = new ContextImpl();
        try {
            parser.parseScript(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parseScript(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            script = parser.parseScript(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)script);
        Assert.assertEquals((Object)"#!/bin/sh\n# --- Enable error detection. ---\nset -e\n\n# --- Set version of this package ---\nTHISVERSION=\"${deb.version}\"\n\necho Pre-installation script version $THISVERSION\necho \"   Parameters                  : $@\"\necho \"   Option                      : $1\"\necho \"   Currently installed version : $2\"\necho \"   Version of this package     : $THISVERSION\"\n\ncase \"$1\" in\n    install)\n        echo \"   No tasks.\"\n        ;;\n    upgrade)\n        echo \"   No tasks.\"\n        ;;\n    *)\n        echo \"   Option $1 not supported by this script.\"\n        ;;\nesac\n", (Object)script.getText());
    }
}

