/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.DebianPackage;
import net.sourceforge.javadpkg.DebianPackageParseHandler;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.DebianPackageParseCollectHandler;
import net.sourceforge.javadpkg.impl.DebianPackageParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DebianPackageParserImplTest
extends AbstractDpkgTest {
    @Test
    @Ignore
    public void test() {
        File folder = new File(System.getProperty("user.home"), "Desktop/Ubuntu");
        Assert.assertTrue((String)("Directory |" + folder.getAbsolutePath() + "| doesn't exist."), (folder.exists() && folder.isDirectory() ? 1 : 0) != 0);
        List<File> files = this.getDebFiles(folder);
        System.out.println(files.size() + " files found.");
        DebianPackageParserImpl parser = new DebianPackageParserImpl();
        ArrayList<Warning> allWarnings = new ArrayList<Warning>();
        for (File file : files) {
            DebianPackage deb;
            System.out.println(file.getAbsolutePath());
            ContextImpl context = new ContextImpl();
            DebianPackageParseCollectHandler handler = new DebianPackageParseCollectHandler();
            try (DataFileSource source = new DataFileSource(file);){
                deb = parser.parseDebianPackage((DataSource)source, (DebianPackageParseHandler)handler, (Context)context);
            }
            catch (IOException | ParseException e) {
                e.printStackTrace();
                Assert.fail((String)("Error while reading file |" + file.getAbsolutePath() + "|: " + e.getMessage()));
                return;
            }
            Assert.assertNotNull((Object)deb);
            Assert.assertEquals((Object)"2.0", (Object)deb.getFileFormatVersion());
            Control control = deb.getControl();
            Assert.assertNotNull((Object)control);
            Assert.assertSame(BinaryControlImpl.class, control.getClass());
            handler.printFiles(System.out);
            List warnings = context.getWarnings();
            if (warnings.isEmpty()) continue;
            allWarnings.addAll(warnings);
        }
        this.printWarnings(allWarnings);
        Assert.fail((String)"Not yet implemented");
    }

    private List<File> getDebFiles(File folder) {
        System.out.println(folder.getAbsolutePath());
        File[] files = folder.listFiles();
        Assert.assertNotNull((Object)files);
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".deb")) {
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileList.addAll(this.getDebFiles(file));
        }
        return fileList;
    }

    private void printWarnings(List<Warning> warnings) {
        List warns;
        LinkedHashMap warnMap = new LinkedHashMap();
        for (Warning warning : warnings) {
            warns = (ArrayList<Warning>)warnMap.get(warning.getClass());
            if (warns == null) {
                warns = new ArrayList<Warning>();
                warnMap.put(warning.getClass(), (ArrayList<Warning>)warns);
            }
            warns.add(warning);
        }
        ArrayList classes = new ArrayList(warnMap.keySet());
        Collections.sort(classes, new ClassComparator());
        for (Class clazz : classes) {
            System.out.println(clazz.getSimpleName());
            warns = (List)warnMap.get(clazz);
            for (Warning warning : warns) {
                System.out.println("\t" + warning.getText());
            }
        }
    }

    private class ClassComparator
    implements Comparator<Class<?>> {
        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    }
}

