/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.DebianPackageParseHandler;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileMetaData;

public class DebianPackageParseCollectHandler
implements DebianPackageParseHandler {
    private List<FileMetaData> files = new ArrayList<FileMetaData>();

    public void handleData(FileMetaData metaData, DataSource source) throws IOException, ParseException {
        if (metaData == null) {
            throw new IllegalArgumentException("Argument metaData is null.");
        }
        if (metaData.isFile() && source == null) {
            throw new IllegalArgumentException("Argument metaData is a file, but argument source is null.");
        }
        this.files.add(metaData);
    }

    public List<FileMetaData> getFiles() {
        return new ArrayList<FileMetaData>(this.files);
    }

    public void printFiles(PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        for (FileMetaData file : this.files) {
            Long groupId = file.getOwner().getGroupId();
            Long userId = file.getOwner().getUserId();
            Long length = file.isDirectory() && file.getLength() < 0L ? Long.valueOf(0L) : Long.valueOf(file.getLength());
            out.println(String.format("%s %5d %-8s %5d %-8s %10d %s", file.getModeAsText(), groupId, file.getOwner().getGroupName(), userId, file.getOwner().getUserName(), length, file.getAbsolutePath()));
        }
    }
}

