/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;
import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightLicense;
import net.sourceforge.javadpkg.DebianPackage;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.DebianPackageBuilderFactory;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.DebianPackageParseHandler;
import net.sourceforge.javadpkg.DebianPackageParser;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.impl.ChangeLogImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryDetailImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.CopyrightImpl;
import net.sourceforge.javadpkg.impl.CopyrightLicenseImpl;
import net.sourceforge.javadpkg.impl.DebianPackageBuilderFactoryImpl;
import net.sourceforge.javadpkg.impl.DebianPackageParseCollectHandler;
import net.sourceforge.javadpkg.impl.DebianPackageParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.FileMetaData;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.Streams;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DebianPackageBuilderImplTest
extends AbstractDpkgTest
implements DebianPackageConstants {
    private DebianPackageParser parser;
    private DebianPackageBuilderFactory debianPackageBuilderFactory;
    private File userHome;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.parser = new DebianPackageParserImpl();
        this.debianPackageBuilderFactory = new DebianPackageBuilderFactoryImpl();
        this.userHome = new File(System.getProperty("user.home"));
    }

    @Test
    public void testParameters() {
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        try {
            builder.buildDebianPackage(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        try {
            try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
                builder.buildDebianPackage((DataTarget)target, null);
            }
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException target) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
    }

    @Test
    public void testMissingControl() {
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        try {
            try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
                builder.buildDebianPackage((DataTarget)target, (Context)context);
            }
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalStateException target) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
    }

    @Test
    public void testMissingCopyright() {
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = DebianPackageBuilderImplTest.createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)", 12345L, "http://www.example.com/", "John Doe <j.doe@example.com>", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        builder.setControl((Control)control);
        try {
            try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
                builder.buildDebianPackage((DataTarget)target, (Context)context);
            }
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalStateException target) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
    }

    @Test
    public void testMissingChangeLog() {
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = DebianPackageBuilderImplTest.createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)", 12345L, "http://www.example.com/", "John Doe <j.doe@example.com>", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        builder.setControl((Control)control);
        builder.setCopyright(this.createCopyright());
        try {
            try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
                builder.buildDebianPackage((DataTarget)target, (Context)context);
            }
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalStateException target) {
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
    }

    @Test
    public void testNoFiles() {
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = DebianPackageBuilderImplTest.createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)", 12345L, "http://www.example.com/", "John Doe <j.doe@example.com>", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        builder.setControl((Control)control);
        builder.setCopyright(this.createCopyright());
        builder.setChangeLog(this.createChangeLog((BinaryControl)control));
        try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
            builder.buildDebianPackage((DataTarget)target, (Context)context);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        DebianPackageParseCollectHandler handler = new DebianPackageParseCollectHandler();
        this.parseDebianPackage(out.toByteArray(), handler);
        handler.printFiles(System.out);
        List<FileMetaData> files = handler.getFiles();
        Assert.assertEquals((long)5L, (long)files.size());
        Assert.assertEquals((Object)"/", (Object)files.get(0).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/", (Object)files.get(1).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/share/", (Object)files.get(2).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/share/doc/", (Object)files.get(3).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/share/doc/mypackage/", (Object)files.get(4).getAbsolutePath());
    }

    @Test
    public void testSomeFiles() {
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = DebianPackageBuilderImplTest.createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)", null, "http://www.example.com/", "John Doe <j.doe@example.com>", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        builder.setControl((Control)control);
        builder.addDataDirectory("/usr");
        builder.addDataDirectory("/usr/local");
        builder.addDataDirectory("/usr/local/myprogram");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(1000, "myprogram"), "/usr/local/myprogram/myprogram", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493));
        builder.addDataSymLink("/usr/local/myprogram/mylink", "/usr/local/myprogram", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493));
        builder.addDataDirectory("/usr/local/myprogram/libs");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(2000, "first.jar"), "/usr/local/myprogram/libs/first.jar");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(50000, "second.jar"), "/usr/local/myprogram/libs/second.jar");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(100000, "third.jar"), "/usr/local/myprogram/libs/third.jar");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(25000, "fourth.jar"), "/usr/local/myprogram/libs/fourth.jar");
        builder.setCopyright(this.createCopyright());
        builder.setChangeLog(this.createChangeLog((BinaryControl)control));
        try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
            builder.buildDebianPackage((DataTarget)target, (Context)context);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        DebianPackageParseCollectHandler handler = new DebianPackageParseCollectHandler();
        this.parseDebianPackage(out.toByteArray(), handler);
        handler.printFiles(System.out);
        List<FileMetaData> files = handler.getFiles();
        Assert.assertEquals((long)14L, (long)files.size());
        Assert.assertEquals((Object)"/", (Object)files.get(0).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/", (Object)files.get(1).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/", (Object)files.get(2).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/", (Object)files.get(3).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/libs/", (Object)files.get(4).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/libs/first.jar", (Object)files.get(5).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/libs/fourth.jar", (Object)files.get(6).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/libs/second.jar", (Object)files.get(7).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/libs/third.jar", (Object)files.get(8).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/mylink", (Object)files.get(9).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/local/myprogram/myprogram", (Object)files.get(10).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/share/", (Object)files.get(11).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/share/doc/", (Object)files.get(12).getAbsolutePath());
        Assert.assertEquals((Object)"/usr/share/doc/mypackage/", (Object)files.get(13).getAbsolutePath());
    }

    @Test
    @Ignore
    public void testWritePackage() {
        Throwable throwable;
        DebianPackageBuilder builder = this.debianPackageBuilderFactory.createDebianPackageBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContextImpl context = new ContextImpl();
        BinaryControlImpl control = DebianPackageBuilderImplTest.createBinaryControl("mypackage", "1.0.0", "net", "optional", "amd64", "oracle-8-jre (>= 1.8.0)", null, "http://www.example.com/", "John Doe <j.doe@example.com>", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n.");
        builder.setControl((Control)control);
        builder.addDataDirectory("/usr");
        builder.addDataDirectory("/usr/local");
        builder.addDataDirectory("/usr/local/myprogram");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(1000, "myprogram"), "/usr/local/myprogram/myprogram", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493));
        builder.addDataSymLink("/usr/local/mylink", "/usr/local/myprogram", (FileOwner)new FileOwnerImpl(0L, "root", 0L, "root"), (FileMode)new FileModeImpl(493));
        builder.addDataDirectory("/usr/local/myprogram/libs");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(2000, "first.jar"), "/usr/local/myprogram/libs/first.jar");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(50000, "second.jar"), "/usr/local/myprogram/libs/second.jar");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(100000, "third.jar"), "/usr/local/myprogram/libs/third.jar");
        builder.addDataFile(DebianPackageBuilderImplTest.createSource(25000, "fourth.jar"), "/usr/local/myprogram/libs/fourth.jar");
        builder.setCopyright(this.createCopyright());
        builder.setChangeLog(this.createChangeLog((BinaryControl)control));
        try {
            throwable = null;
            try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, "test.deb", false);){
                builder.buildDebianPackage((DataTarget)target, (Context)context);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        catch (BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't create Debian package: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        try {
            throwable = null;
            try (OutputStream fos = Streams.createBufferedFileOutputStream((File)new File(this.userHome, "Desktop\\mypackage-1.0.0-amd64.deb"));){
                Streams.copy((InputStream)new ByteArrayInputStream(out.toByteArray()), (OutputStream)fos);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
    }

    private Copyright createCopyright() {
        CopyrightImpl copyright = new CopyrightImpl();
        copyright.setFormat("http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/");
        copyright.setCopyright("(c) 2015, John Doe");
        CopyrightLicenseImpl license = new CopyrightLicenseImpl();
        license.setName("MyLicense");
        license.setText("This is my license...");
        copyright.setLicense((CopyrightLicense)license);
        return copyright;
    }

    private ChangeLog createChangeLog(BinaryControl control) {
        ChangeLogImpl changeLog = new ChangeLogImpl();
        ChangeLogVersionEntryImpl entry = new ChangeLogVersionEntryImpl();
        entry.setPackageName(control.getPackage());
        entry.setVersion(control.getVersion());
        entry.setDistributions(Arrays.asList("lucid"));
        entry.setUrgency(DebianPackageBuilderImplTest.createChangeLogUrgency("low"));
        ChangeLogVersionEntryDetailImpl detail = new ChangeLogVersionEntryDetailImpl("First version of the package.");
        entry.addDetail((ChangeLogVersionEntryDetail)detail);
        entry.setMaintainer(control.getMaintainer());
        entry.setDate(new Date(1462778238028L));
        changeLog.addEntry((ChangeLogVersionEntry)entry);
        return changeLog;
    }

    private DebianPackage parseDebianPackage(byte[] data, DebianPackageParseHandler handler) {
        DebianPackage debianPackage;
        ContextImpl context = new ContextImpl();
        try (DataStreamSource source = new DataStreamSource((InputStream)new ByteArrayInputStream(data), "control", false);){
            debianPackage = this.parser.parseDebianPackage((DataSource)source, handler, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("The Debian package is invalid: " + e.getMessage()));
            return null;
        }
        return debianPackage;
    }
}

