/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightLicense;
import net.sourceforge.javadpkg.FilesCopyright;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Warning;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.CopyrightParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class CopyrightParserImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        Copyright copyright;
        CopyrightParserImpl parser = new CopyrightParserImpl();
        DataSource source = CopyrightParserImplTest.createSource(Arrays.asList(""), "copyright");
        ContextImpl context = new ContextImpl();
        try {
            parser.parseCopyright(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parseCopyright(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        source = CopyrightParserImplTest.createSource(Arrays.asList("Format: http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/", "Upstream-Name: SOFTware", "Upstream-Contact: John Doe <john.doe@example.com>", "Source: http://www.example.com/software/project"), "copyright");
        try {
            copyright = parser.parseCopyright(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)copyright);
        Assert.assertEquals((Object)"http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/", (Object)copyright.getFormat());
        Assert.assertEquals((Object)"SOFTware", (Object)copyright.getUpstreamName());
        Assert.assertEquals((Object)"John Doe <john.doe@example.com>", (Object)copyright.getUpstreamContact());
        Assert.assertEquals((Object)"http://www.example.com/software/project", (Object)copyright.getSource());
        Assert.assertNull((Object)copyright.getDisclaimer());
        Assert.assertNull((Object)copyright.getComment());
        Assert.assertNull((Object)copyright.getLicense());
        Assert.assertNull((Object)copyright.getCopyright());
        List filesCopyrights = copyright.getFilesCopyrights();
        Assert.assertNotNull((Object)filesCopyrights);
        Assert.assertEquals((long)0L, (long)filesCopyrights.size());
        Map licenses = copyright.getLicenses();
        Assert.assertNotNull((Object)licenses);
        Assert.assertEquals((long)0L, (long)licenses.size());
        source = CopyrightParserImplTest.createSource(Arrays.asList("Format: http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/", "Upstream-Name: SOFTware", "Upstream-Contact: John Doe <john.doe@example.com>", "Source: http://www.example.com/software/project", "Disclaimer: disclaimer", "Comment: comment", "License: MPL-1.1 or GPL-2 or LGPL-2.1", "Copyright: 1993, John Doe", " 1993, Joe Average", "", "Files: src/js/editline/*", "Copyright: 1993, John Doe", " 1993, Joe Average", "", "Files: src/js/fdlibm/*", "Copyright: 1993, J-Random Corporation", "License: MPL-1.1", "", "Files: src/js/liba/* src/js/libb/*", "Copyright: 2014, A-Corporation", "", "License: MPL-1.1", " [MPL-1.1-LICENSE-TEXT]", "", "License: GPL-2", " [GPL-2-LICENSE-TEXT]", "", "License: LGPL-2.1", " [LGPL-2.1-LICENSE-TEXT]"), "copyright");
        try {
            copyright = parser.parseCopyright(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)copyright);
        Assert.assertEquals((Object)"http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/", (Object)copyright.getFormat());
        Assert.assertEquals((Object)"SOFTware", (Object)copyright.getUpstreamName());
        Assert.assertEquals((Object)"John Doe <john.doe@example.com>", (Object)copyright.getUpstreamContact());
        Assert.assertEquals((Object)"http://www.example.com/software/project", (Object)copyright.getSource());
        Assert.assertEquals((Object)"disclaimer", (Object)copyright.getDisclaimer());
        Assert.assertEquals((Object)"comment", (Object)copyright.getComment());
        CopyrightLicense license = copyright.getLicense();
        Assert.assertNotNull((Object)license);
        Assert.assertEquals((Object)"MPL-1.1 or GPL-2 or LGPL-2.1", (Object)license.getName());
        Assert.assertNull((Object)license.getText());
        Assert.assertNull((Object)license.getComment());
        Assert.assertEquals((Object)"1993, John Doe\n1993, Joe Average", (Object)copyright.getCopyright());
        filesCopyrights = copyright.getFilesCopyrights();
        Assert.assertNotNull((Object)filesCopyrights);
        Assert.assertEquals((long)3L, (long)filesCopyrights.size());
        FilesCopyright filesCopyright = (FilesCopyright)filesCopyrights.get(0);
        Assert.assertNotNull((Object)filesCopyright);
        List patterns = filesCopyright.getFiles();
        Assert.assertNotNull((Object)patterns);
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertEquals((Object)"src/js/editline/*", patterns.get(0));
        Assert.assertEquals((Object)"1993, John Doe\n1993, Joe Average", (Object)filesCopyright.getCopyright());
        Assert.assertNull((Object)filesCopyright.getLicense());
        Assert.assertNull((Object)filesCopyright.getComment());
        filesCopyright = (FilesCopyright)filesCopyrights.get(1);
        Assert.assertNotNull((Object)filesCopyright);
        patterns = filesCopyright.getFiles();
        Assert.assertNotNull((Object)patterns);
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertEquals((Object)"src/js/fdlibm/*", patterns.get(0));
        Assert.assertEquals((Object)"1993, J-Random Corporation", (Object)filesCopyright.getCopyright());
        license = filesCopyright.getLicense();
        Assert.assertNotNull((Object)license);
        Assert.assertEquals((Object)"MPL-1.1", (Object)license.getName());
        Assert.assertNull((Object)license.getText());
        Assert.assertNull((Object)license.getComment());
        Assert.assertNull((Object)filesCopyright.getComment());
        filesCopyright = (FilesCopyright)filesCopyrights.get(2);
        Assert.assertNotNull((Object)filesCopyright);
        patterns = filesCopyright.getFiles();
        Assert.assertNotNull((Object)patterns);
        Assert.assertEquals((long)2L, (long)patterns.size());
        Assert.assertEquals((Object)"src/js/liba/*", patterns.get(0));
        Assert.assertEquals((Object)"src/js/libb/*", patterns.get(1));
        Assert.assertEquals((Object)"2014, A-Corporation", (Object)filesCopyright.getCopyright());
        Assert.assertNull((Object)filesCopyright.getLicense());
        Assert.assertNull((Object)filesCopyright.getComment());
        licenses = copyright.getLicenses();
        Assert.assertNotNull((Object)licenses);
        Assert.assertEquals((long)3L, (long)licenses.size());
        license = (CopyrightLicense)licenses.get("MPL-1.1");
        Assert.assertNotNull((Object)license);
        Assert.assertEquals((Object)"MPL-1.1", (Object)license.getName());
        Assert.assertEquals((Object)"[MPL-1.1-LICENSE-TEXT]", (Object)license.getText());
        Assert.assertNull((Object)license.getComment());
        license = (CopyrightLicense)licenses.get("GPL-2");
        Assert.assertNotNull((Object)license);
        Assert.assertEquals((Object)"GPL-2", (Object)license.getName());
        Assert.assertEquals((Object)"[GPL-2-LICENSE-TEXT]", (Object)license.getText());
        Assert.assertNull((Object)license.getComment());
        license = (CopyrightLicense)licenses.get("LGPL-2.1");
        Assert.assertNotNull((Object)license);
        Assert.assertEquals((Object)"LGPL-2.1", (Object)license.getName());
        Assert.assertEquals((Object)"[LGPL-2.1-LICENSE-TEXT]", (Object)license.getText());
        Assert.assertNull((Object)license.getComment());
        source = CopyrightParserImplTest.createSource(Arrays.asList("Source: http://linux.dell.com/dkms/", "", "Files: debian/HOWTO.Debian", "Copyright: \u00a9 2008, Dell, Inc. <dkms-devel@lists.us.dell.com>", "                   Mario Limonciello <Mario_Limonciello@dell.com>", "License: GPL-2+", " This package is free software; you can redistribute it and/or modify", " it under the terms of the GNU General Public License as published by", " the Free Software Foundation; either version 2 of the License, or", " (at your option) any later version.", "", "Files: debian/*", "Copyright: \u00a9 2008-2009, David Paleino <d.paleino@gmail.com>", "           \u00a9 2005-2008, Matt Domsch <Matt_Domsch@dell.com>", "           \u00a9 2008-2009, Mario Limonciello <Mario_Limonciello@dell.com>", "           \u00a9 2008-2009, Giuseppe Iuculano <giuseppe@iuculano.it>", "License: GPL-2+", "", "Files: *", "Copyright: \u00a9 2003-2009, Dell, Inc. <dkms-devel@lists.us.dell.com>", "License: GPL-2+", "", "On Debian systems, the complete text of the GNU General", "Public License v2 can be found in `/usr/share/common-licenses/GPL-2'."), "copyright");
        try {
            copyright = parser.parseCopyright(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)1L, (long)warnings.size());
        Warning warning = (Warning)warnings.get(0);
        Assert.assertEquals((Object)"The copyright has an unsupported format.", (Object)warning.getText());
        Assert.assertNotNull((Object)copyright);
        Assert.assertNull((Object)copyright.getFormat());
        Assert.assertNull((Object)copyright.getUpstreamName());
        Assert.assertNull((Object)copyright.getUpstreamContact());
        Assert.assertNull((Object)copyright.getSource());
        Assert.assertNull((Object)copyright.getDisclaimer());
        Assert.assertNull((Object)copyright.getComment());
        Assert.assertNull((Object)copyright.getLicense());
        Assert.assertNull((Object)copyright.getCopyright());
        filesCopyrights = copyright.getFilesCopyrights();
        Assert.assertNotNull((Object)filesCopyrights);
        Assert.assertEquals((long)0L, (long)filesCopyrights.size());
        licenses = copyright.getLicenses();
        Assert.assertNotNull((Object)licenses);
        Assert.assertEquals((long)0L, (long)licenses.size());
    }
}

