/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightLicense;
import net.sourceforge.javadpkg.FilesCopyright;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.CopyrightBuilderImpl;
import net.sourceforge.javadpkg.impl.CopyrightImpl;
import net.sourceforge.javadpkg.impl.CopyrightLicenseImpl;
import net.sourceforge.javadpkg.impl.FilesCopyrightImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import org.junit.Assert;
import org.junit.Test;

public class CopyrightBuilderImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        CopyrightBuilderImpl builder = new CopyrightBuilderImpl();
        CopyrightImpl copyright = new CopyrightImpl();
        ContextImpl context = new ContextImpl();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataStreamTarget target = new DataStreamTarget((OutputStream)out, "copyright", false);
        try {
            builder.buildCopyright(null, (DataTarget)target, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildCopyright((Copyright)copyright, null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildCopyright((Copyright)copyright, (DataTarget)target, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        out = new ByteArrayOutputStream();
        target = new DataStreamTarget((OutputStream)out, "copyright", false);
        copyright.setFormat("http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/");
        copyright.setUpstreamName("SOFTware");
        copyright.setUpstreamContact("John Doe <john.doe@example.com>");
        copyright.setSource("http://www.example.com/software/project");
        try {
            builder.buildCopyright((Copyright)copyright, (DataTarget)target, (Context)context);
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"Format: http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/\nUpstream-Name: SOFTware\nUpstream-Contact: John Doe <john.doe@example.com>\nSource: http://www.example.com/software/project\n", (Object)new String(out.toByteArray()));
        out = new ByteArrayOutputStream();
        target = new DataStreamTarget((OutputStream)out, "copyright", false);
        copyright.setFormat("http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/");
        copyright.setUpstreamName("SOFTware");
        copyright.setUpstreamContact("John Doe <john.doe@example.com>");
        copyright.setSource("http://www.example.com/software/project");
        copyright.setDisclaimer("disclaimer");
        copyright.setComment("comment");
        CopyrightLicenseImpl license = new CopyrightLicenseImpl();
        license.setName("MPL-1.1 or GPL-2 or LGPL-2.1");
        copyright.setLicense((CopyrightLicense)license);
        copyright.setCopyright("1993, John Doe\n1993, Joe Average");
        FilesCopyrightImpl filesCopyright = new FilesCopyrightImpl();
        filesCopyright.setFiles(Arrays.asList("src/js/editline/*"));
        filesCopyright.setCopyright("1993, John Doe\n1993, Joe Average");
        copyright.addFilesCopyright((FilesCopyright)filesCopyright);
        filesCopyright = new FilesCopyrightImpl();
        filesCopyright.setFiles(Arrays.asList("src/js/fdlibm/*"));
        filesCopyright.setCopyright("1993, J-Random Corporation");
        license = new CopyrightLicenseImpl();
        license.setName("MPL-1.1");
        filesCopyright.setLicense((CopyrightLicense)license);
        copyright.addFilesCopyright((FilesCopyright)filesCopyright);
        filesCopyright = new FilesCopyrightImpl();
        filesCopyright.setFiles(Arrays.asList("src/js/liba/* src/js/libb/*"));
        filesCopyright.setCopyright("2014, A-Corporation");
        copyright.addFilesCopyright((FilesCopyright)filesCopyright);
        license = new CopyrightLicenseImpl();
        license.setName("MPL-1.1");
        license.setText("[MPL-1.1-LICENSE-TEXT]");
        copyright.addLicense((CopyrightLicense)license);
        license = new CopyrightLicenseImpl();
        license.setName("GPL-2");
        license.setText("[GPL-2-LICENSE-TEXT]");
        copyright.addLicense((CopyrightLicense)license);
        license = new CopyrightLicenseImpl();
        license.setName("LGPL-2.1");
        license.setText("[LGPL-2.1-LICENSE-TEXT]");
        copyright.addLicense((CopyrightLicense)license);
        try {
            builder.buildCopyright((Copyright)copyright, (DataTarget)target, (Context)context);
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"Format: http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/\nUpstream-Name: SOFTware\nUpstream-Contact: John Doe <john.doe@example.com>\nSource: http://www.example.com/software/project\nDisclaimer: disclaimer\nComment: comment\nLicense: MPL-1.1 or GPL-2 or LGPL-2.1\nCopyright: 1993, John Doe\n 1993, Joe Average\n\nFiles: src/js/editline/*\nCopyright: 1993, John Doe\n 1993, Joe Average\n\nFiles: src/js/fdlibm/*\nCopyright: 1993, J-Random Corporation\nLicense: MPL-1.1\n\nFiles: src/js/liba/* src/js/libb/*\nCopyright: 2014, A-Corporation\n\nLicense: MPL-1.1\n [MPL-1.1-LICENSE-TEXT]\n\nLicense: GPL-2\n [GPL-2-LICENSE-TEXT]\n\nLicense: LGPL-2.1\n [LGPL-2.1-LICENSE-TEXT]\n", (Object)new String(out.toByteArray()));
    }
}

